<?php
/**
 * User Login Page
 */
require_once __DIR__ . '/config.php';

if (isLoggedIn()) {
    redirect('/user/dashboard.php');
}

$csrfToken = generateCSRFToken();
$error = '';
$banned = isset($_GET['banned']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrf = $_POST['csrf_token'] ?? '';
    if (!verifyCSRFToken($csrf)) {
        $error = 'Invalid security token. Please refresh.';
    } else {
        if (!rateLimit('login', 5, 5)) {
            $error = 'Too many login attempts. Please wait 5 minutes.';
        } else {
            $phone = preg_replace('/[^0-9]/', '', $_POST['phone'] ?? '');
            $password = $_POST['password'] ?? '';
            
            if (empty($phone) || empty($password)) {
                $error = 'Please enter phone number and password';
            } else {
                $user = getUserByPhone($phone);
                
                if (!$user) {
                    $error = 'No account found with this phone number';
                } elseif (!password_verify($password, $user['password'])) {
                    $error = 'Incorrect password';
                } elseif ($user['status'] === 'banned') {
                    $error = 'Your account has been blocked. Contact support.';
                } else {
                    loginUser((int)$user['id']);
                    
                    // Redirect
                    $redirect = $_POST['redirect'] ?? '/user/dashboard.php';
                    if (strpos($redirect, '/') !== 0) $redirect = '/user/dashboard.php';
                    redirect($redirect);
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <meta name="theme-color" content="#1a1a2e">
    <title>Login — Hindustan Club</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <link href="/assets/css/style.css" rel="stylesheet">
</head>
<body class="auth-body">
<div class="auth-container">
    <div class="auth-card">
        <div class="auth-logo">
            <div class="auth-logo-icon">HC</div>
            <h1 class="auth-title">Welcome Back!</h1>
            <p class="auth-sub">Login to your Hindustan Club account</p>
        </div>
        
        <?php if ($banned): ?>
        <div class="auth-alert auth-alert-error">
            <i class="fas fa-ban"></i> Your account has been blocked. Contact support.
        </div>
        <?php endif; ?>
        
        <?php if ($error): ?>
        <div class="auth-alert auth-alert-error">
            <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?>
        </div>
        <?php endif; ?>
        
        <form method="POST" class="auth-form" id="loginForm">
            <input type="hidden" name="csrf_token" value="<?php echo $csrfToken; ?>">
            <input type="hidden" name="redirect" value="<?php echo htmlspecialchars($_GET['redirect'] ?? '/user/dashboard.php'); ?>">
            
            <div class="auth-field">
                <label class="auth-label">Mobile Number</label>
                <div class="auth-input-wrap">
                    <span class="auth-input-prefix">+91</span>
                    <input type="tel" name="phone" class="auth-input auth-input-phone" placeholder="10-digit mobile number" value="<?php echo htmlspecialchars($_POST['phone'] ?? ''); ?>" required maxlength="10" pattern="[6-9][0-9]{9}" autocomplete="tel">
                </div>
            </div>
            
            <div class="auth-field">
                <label class="auth-label">Password</label>
                <div class="auth-input-wrap">
                    <i class="fas fa-lock auth-input-icon"></i>
                    <input type="password" name="password" id="loginPassword" class="auth-input" placeholder="Enter password" required autocomplete="current-password">
                    <button type="button" class="auth-eye-btn" onclick="toggleEye('loginPassword', this)"><i class="fas fa-eye"></i></button>
                </div>
            </div>
            
            <button type="submit" class="auth-submit-btn" id="loginBtn">
                <i class="fas fa-sign-in-alt"></i> Login
            </button>
        </form>
        
        <div class="auth-footer">
            Don't have an account? <a href="/register.php" class="auth-link">Register</a>
        </div>
    </div>
</div>

<script>
function toggleEye(id,btn){var i=document.getElementById(id),ic=btn.querySelector('i');if(i.type==='password'){i.type='text';ic.className='fas fa-eye-slash';}else{i.type='password';ic.className='fas fa-eye';}}
document.getElementById('loginForm').addEventListener('submit',function(){var b=document.getElementById('loginBtn');b.disabled=true;b.innerHTML='<i class="fas fa-spinner fa-spin"></i> Logging in...';});
</script>
</body>
</html>