<?php
/**
 * HINDUSTAN CLUB - Main Config v2.0
 * Sirf neeche ke 4 values apne server ke hisab se change karo
 */

define('DB_HOST',    'localhost');
define('DB_NAME',    'preposts_data');  // << apna database naam
define('DB_USER',    'root');           // << apna db user
define('DB_PASS',    '');               // << apna db password
define('DB_CHARSET', 'utf8mb4');
define('BASE_PATH',  __DIR__);
define('UPLOADS_DIR', __DIR__ . '/uploads');
define('BASE_URL',   'https://yourdomain.com'); // << apna domain

if (session_status() === PHP_SESSION_NONE) {
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_strict_mode', 1);
    session_start();
}

// DB functions
function db(): PDO {
    static $pdo = null;
    if ($pdo) return $pdo;
    $pdo = new PDO('mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset='.DB_CHARSET, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);
    return $pdo;
}
function query(string $sql, array $p = []): \PDOStatement { $s = db()->prepare($sql); $s->execute($p); return $s; }
function fetch(string $sql, array $p = []): ?array { $r = query($sql,$p)->fetch(); return $r ?: null; }
function fetchAll(string $sql, array $p = []): array { return query($sql,$p)->fetchAll(); }
function insert(string $t, array $d): int {
    $c = implode(',', array_map(fn($x) => "`$x`", array_keys($d)));
    $ph = implode(',', array_fill(0, count($d), '?'));
    query("INSERT INTO `$t` ($c) VALUES ($ph)", array_values($d));
    return (int)db()->lastInsertId();
}
function update(string $t, array $d, string $w, array $wp = []): int {
    $set = implode(',', array_map(fn($x) => "`$x`=?", array_keys($d)));
    return query("UPDATE `$t` SET $set WHERE $w", array_merge(array_values($d), $wp))->rowCount();
}
function deleteRow(string $t, string $w, array $p = []): int { return query("DELETE FROM `$t` WHERE $w", $p)->rowCount(); }

function getSetting(string $key, string $default = ''): string {
    static $c = [];
    if (!isset($c[$key])) { $r = fetch("SELECT `value` FROM `site_settings` WHERE `key`=? LIMIT 1", [$key]); $c[$key] = $r ? $r['value'] : $default; }
    return $c[$key];
}

function sanitize(string $v): string { return htmlspecialchars(trim($v), ENT_QUOTES, 'UTF-8'); }
function jsonResponse(bool $ok, string $msg = '', array $data = []): never {
    header('Content-Type: application/json');
    echo json_encode(array_merge(['success'=>$ok,'message'=>$msg], $data));
    exit;
}

// Auth
function requireLogin(): void {
    if (empty($_SESSION['user_id'])) {
        if (!empty($_SERVER['HTTP_X_REQUESTED_WITH'])) jsonResponse(false, 'Not logged in');
        header('Location: /Login.php'); exit;
    }
}
function getCurrentUserId(): int { return (int)($_SESSION['user_id'] ?? 0); }
function getCurrentUser(): ?array { $id = getCurrentUserId(); return $id ? getUserById($id) : null; }
function getUserById(int $id): ?array { return fetch("SELECT * FROM `users` WHERE `id`=? LIMIT 1", [$id]); }

function generateCSRFToken(): string {
    if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    return $_SESSION['csrf_token'];
}
function verifyCSRFToken(string $t): bool { return !empty($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $t); }

function rateLimit(string $key, int $max, int $min): bool {
    $since = date('Y-m-d H:i:s', time() - $min * 60);
    $c = (int)(fetch("SELECT COUNT(*) as c FROM `rate_limits` WHERE `key`=? AND `created_at`>?", [$key, $since])['c'] ?? 0);
    if ($c >= $max) return false;
    insert('rate_limits', ['key'=>$key,'ip'=>$_SERVER['REMOTE_ADDR']??'']);
    return true;
}

function addNotification(int $uid, string $title, string $msg, string $type = 'system', string $link = ''): void {
    insert('notifications', ['user_id'=>$uid,'title'=>$title,'message'=>$msg,'type'=>$type,'link'=>$link]);
}

// ============================================================
// 3-WALLET SYSTEM
// deposit_balance  = Deposited money  -> games me PEHLE use hota hai, withdrawable
// earning_balance  = Game jeet + referral -> withdrawable
// bonus_balance    = Gift/promo bonus -> games me use hota hai, withdraw NAHI hota
// Khelne ka order: deposit -> earning -> bonus
// ============================================================

function getWallet(int $uid): array {
    $w = fetch("SELECT * FROM `wallets` WHERE `user_id`=? LIMIT 1", [$uid]);
    if (!$w) {
        insert('wallets', ['user_id'=>$uid,'deposit_balance'=>0,'earning_balance'=>0,'bonus_balance'=>0,
                           'total_deposited'=>0,'total_withdrawn'=>0,'total_wagered'=>0,'wagering_required'=>0]);
        return ['deposit_balance'=>0.0,'earning_balance'=>0.0,'bonus_balance'=>0.0,
                'total_deposited'=>0.0,'total_withdrawn'=>0.0,'total_wagered'=>0.0,'wagering_required'=>0.0];
    }
    return $w;
}

// Teeno wallet ka total (khelne ke liye)
function getTotalBalance(int $uid): float {
    $w = getWallet($uid);
    return round((float)$w['deposit_balance'] + (float)$w['earning_balance'] + (float)$w['bonus_balance'], 2);
}

// Sirf withdraw karne layak (deposit + earning, bonus nahi)
function getWithdrawableBalance(int $uid): float {
    $w = getWallet($uid);
    return round((float)$w['deposit_balance'] + (float)$w['earning_balance'], 2);
}

// Game ke liye paisa katao: deposit -> earning -> bonus order
function deductFromWallet(int $uid, float $amount, string $type = 'bet', string $desc = ''): array {
    $w = getWallet($uid);
    $total = (float)$w['deposit_balance'] + (float)$w['earning_balance'] + (float)$w['bonus_balance'];
    if ($total < $amount - 0.005) throw new \RuntimeException('Insufficient balance. Available: Rs.' . number_format($total, 2));

    $rem = $amount;
    $d = ['deposit'=>0.0, 'earning'=>0.0, 'bonus'=>0.0];
    if ($rem > 0 && $w['deposit_balance'] > 0) { $t = min($rem,(float)$w['deposit_balance']); $d['deposit']=$t; $rem-=$t; }
    if ($rem > 0 && $w['earning_balance'] > 0) { $t = min($rem,(float)$w['earning_balance']); $d['earning']=$t; $rem-=$t; }
    if ($rem > 0 && $w['bonus_balance'] > 0)   { $t = min($rem,(float)$w['bonus_balance']);   $d['bonus']=$t;   $rem-=$t; }

    update('wallets', [
        'deposit_balance' => max(0, round((float)$w['deposit_balance'] - $d['deposit'], 2)),
        'earning_balance' => max(0, round((float)$w['earning_balance'] - $d['earning'], 2)),
        'bonus_balance'   => max(0, round((float)$w['bonus_balance']   - $d['bonus'],   2)),
        'total_wagered'   => round((float)$w['total_wagered'] + $amount, 2),
    ], 'user_id=?', [$uid]);

    $pri = $d['deposit'] > 0 ? 'deposit' : ($d['earning'] > 0 ? 'earning' : 'bonus');
    insert('transactions', ['user_id'=>$uid,'type'=>$type,'amount'=>-$amount,'wallet_type'=>$pri,
                             'balance_after'=>getTotalBalance($uid),'status'=>'completed','description'=>$desc]);
    return $d;
}
// Backward compat alias
function deductFromMainWallet(int $uid, float $amount, string $type = 'bet', string $desc = ''): array {
    return deductFromWallet($uid, $amount, $type, $desc);
}

// Wallet me paisa daalo
function creditToWallet(int $uid, float $amount, string $walletType = 'earning', string $type = 'credit', string $desc = ''): void {
    if (!in_array($walletType, ['deposit','earning','bonus'])) $walletType = 'earning';
    $col = $walletType . '_balance';
    $w = getWallet($uid);
    $extra = ($walletType === 'deposit') ? ['total_deposited' => round((float)$w['total_deposited'] + $amount, 2)] : [];
    update('wallets', array_merge([$col => round((float)$w[$col] + $amount, 2)], $extra), 'user_id=?', [$uid]);
    insert('transactions', ['user_id'=>$uid,'type'=>$type,'amount'=>$amount,'wallet_type'=>$walletType,
                             'balance_after'=>getTotalBalance($uid),'status'=>'completed','description'=>$desc]);
}
// finance.php ke purane aliases
function addToMainWallet(int $uid, float $amount, string $type = 'credit', string $desc = ''): void { creditToWallet($uid,$amount,'deposit',$type,$desc); }
function addToBonusWallet(int $uid, float $amount, string $type = 'bonus', string $desc = ''): void { creditToWallet($uid,$amount,'bonus',$type,$desc); }

// Approved deposit credit (real money -> deposit wallet, bonus -> bonus wallet)
function creditDeposit(int $uid, float $amount, float $bonus = 0): void {
    creditToWallet($uid, $amount, 'deposit', 'deposit', 'Deposit approved');
    if ($bonus > 0) creditToWallet($uid, $bonus, 'bonus', 'deposit_bonus', 'First deposit bonus');
}
function creditGameWin(int $uid, float $amount, string $game = ''): void  { creditToWallet($uid,$amount,'earning','game_win',"Won: $game"); }
function creditReferralCommission(int $uid, float $amount, string $desc = 'Referral'): void { creditToWallet($uid,$amount,'earning','referral',$desc); }
function creditBonus(int $uid, float $amount, string $desc = 'Bonus'): void { creditToWallet($uid,$amount,'bonus','bonus',$desc); }

// Withdrawal ke liye paisa katao (sirf deposit+earning, bonus nahi)
function deductForWithdrawal(int $uid, float $amount): void {
    $w = getWallet($uid);
    $avail = (float)$w['deposit_balance'] + (float)$w['earning_balance'];
    if ($avail < $amount - 0.005) throw new \RuntimeException('Insufficient withdrawable balance. Available: Rs.' . number_format($avail, 2));
    $rem = $amount; $nd = (float)$w['deposit_balance']; $ne = (float)$w['earning_balance'];
    if ($rem>0&&$nd>0){$t=min($rem,$nd);$nd-=$t;$rem-=$t;}
    if ($rem>0&&$ne>0){$t=min($rem,$ne);$ne-=$t;$rem-=$t;}
    update('wallets', ['deposit_balance'=>max(0,round($nd,2)),'earning_balance'=>max(0,round($ne,2)),'total_withdrawn'=>round((float)$w['total_withdrawn']+$amount,2)], 'user_id=?', [$uid]);
    insert('transactions', ['user_id'=>$uid,'type'=>'withdrawal','amount'=>-$amount,'wallet_type'=>'deposit','balance_after'=>getTotalBalance($uid),'status'=>'completed','description'=>'Withdrawal']);
}

// UPI: single ya multi mode ke hisab se active UPI do
function getActiveUpiForDeposit(): ?array {
    $mode = getSetting('upi_collection_mode', 'multi');
    if ($mode === 'single') return fetch("SELECT * FROM `admin_upi_settings` WHERE `is_active`=1 ORDER BY `priority` DESC LIMIT 1");
    $upis = fetchAll("SELECT * FROM `admin_upi_settings` WHERE `is_active`=1 ORDER BY `priority` DESC");
    foreach ($upis as $u) { if ((float)$u['today_received'] < (float)$u['daily_limit']) return $u; }
    return $upis[0] ?? null;
}

// VIP check
function checkVIPUpgrade(int $uid): void {
    $user = getUserById($uid); if (!$user) return;
    $dep = (float)$user['total_deposited'];
    foreach (fetchAll("SELECT * FROM `vip_levels` ORDER BY `min_deposit` DESC") as $lv) {
        if ($dep >= (float)$lv['min_deposit']) {
            if ((int)$user['vip_level'] < (int)$lv['level']) {
                update('users', ['vip_level'=>$lv['level']], 'id=?', [$uid]);
                addNotification($uid, 'VIP Upgrade!', 'You are now '.$lv['name'].' VIP!', 'vip');
            }
            break;
        }
    }
}

// Algorithm
function shouldUserWin(int $uid): bool {
    $d = fetch("SELECT * FROM `user_algorithm_data` WHERE `user_id`=? LIMIT 1", [$uid]);
    if (!$d) { insert('user_algorithm_data',['user_id'=>$uid,'phase_start_date'=>date('Y-m-d')]); $d = fetch("SELECT * FROM `user_algorithm_data` WHERE `user_id`=? LIMIT 1",[$uid]); }
    $ph = (int)$d['current_phase'];
    $s = fetch("SELECT `value` FROM `algorithm_settings` WHERE `key`=?", ["phase{$ph}_win_rate"]);
    $wr = $s ? (int)$s['value'] : 40;
    if ((int)$d['total_bets'] < (int)getSetting('new_user_free_wins','3')) $wr = max($wr, 65);
    $mc = (int)(fetch("SELECT `value` FROM `algorithm_settings` WHERE `key`='max_consecutive_wins'")['value'] ?? 5);
    if ((int)$d['consecutive_wins'] >= $mc) return false;
    return mt_rand(1,100) <= $wr;
}
function updateAlgorithmData(int $uid, bool $won): void {
    $d = fetch("SELECT * FROM `user_algorithm_data` WHERE `user_id`=? LIMIT 1", [$uid]); if (!$d) return;
    update('user_algorithm_data', ['total_bets'=>(int)$d['total_bets']+1,'total_wins'=>(int)$d['total_wins']+($won?1:0),'total_losses'=>(int)$d['total_losses']+($won?0:1),'consecutive_wins'=>$won?(int)$d['consecutive_wins']+1:0,'consecutive_losses'=>$won?0:(int)$d['consecutive_losses']+1,'last_bet_at'=>date('Y-m-d H:i:s')], 'user_id=?', [$uid]);
}
function updateAlgorithmPhase(int $uid): void {
    $d = fetch("SELECT * FROM `user_algorithm_data` WHERE `user_id`=? LIMIT 1", [$uid]); if (!$d) return;
    $ph = (int)$d['current_phase'];
    $s = fetch("SELECT `value` FROM `algorithm_settings` WHERE `key`=?", ["phase{$ph}_duration_days"]);
    $dur = $s ? (int)$s['value'] : 999;
    $days = (int)((time() - strtotime($d['phase_start_date'] ?? date('Y-m-d'))) / 86400);
    if ($days >= $dur && $ph < 3) update('user_algorithm_data', ['current_phase'=>$ph+1,'phase_start_date'=>date('Y-m-d')], 'user_id=?', [$uid]);
}

// Wingo period
function getCurrentWingoPeriod(int $dur): array {
    $now = time(); $secs = $dur * 60; $block = (int)($now/$secs);
    $start = $block*$secs; $end = $start+$secs;
    $pNum = date('Ymd',$start).'D'.$dur.'B'.str_pad($block%10000,4,'0',STR_PAD_LEFT);
    $ex = fetch("SELECT * FROM `wingo_periods` WHERE `period_number`=? AND `game_duration`=? LIMIT 1", [$pNum,$dur]);
    if (!$ex) {
        insert('wingo_periods',['period_number'=>$pNum,'game_duration'=>$dur,'start_time'=>date('Y-m-d H:i:s',$start),'end_time'=>date('Y-m-d H:i:s',$end),'status'=>'betting']);
        $ex = fetch("SELECT * FROM `wingo_periods` WHERE `period_number`=? AND `game_duration`=? LIMIT 1", [$pNum,$dur]);
    }
    $ex['seconds_left'] = max(0, $end - $now);
    return $ex;
}

// Withdrawal limits
function getDailyWithdrawalLimit(int $uid): float {
    $user = getUserById($uid); $vip = (int)($user['vip_level'] ?? 0);
    $lv = fetch("SELECT * FROM `vip_levels` WHERE `level`=? LIMIT 1", [$vip]);
    return $lv ? (float)$lv['withdrawal_limit'] : 10000.0;
}
function getTodayWithdrawn(int $uid): float {
    $r = fetch("SELECT COALESCE(SUM(`amount`),0) as t FROM `withdrawals` WHERE `user_id`=? AND DATE(`created_at`)=? AND `status` NOT IN ('rejected','cancelled')", [$uid, date('Y-m-d')]);
    return (float)($r['t'] ?? 0);
}

function validateUPI(string $upi): bool { return (bool)preg_match('/^[\w.\-]{2,256}@[a-zA-Z]{2,64}$/', $upi); }

// Upload directories auto-create
foreach (['deposits','upi_qr','brand','avatars'] as $_d) {
    $p = UPLOADS_DIR . '/' . $_d;
    if (!is_dir($p)) { @mkdir($p, 0755, true); @file_put_contents($p.'/.htaccess', "Options -Indexes\n"); }
}
