<?php
/**
 * Profile API — Update name, password, transaction PIN
 */
require_once __DIR__ . '/../config.php';
requireLogin();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') jsonResponse(false, 'Invalid method');
$csrf = $_POST['csrf_token'] ?? '';
if (!verifyCSRFToken($csrf)) jsonResponse(false, 'Invalid token');

$userId = getCurrentUserId();
$action = sanitize($_POST['action'] ?? '');

switch ($action) {
    case 'update_name':
        $name = trim($_POST['name'] ?? '');
        if (!validateName($name)) jsonResponse(false, 'Invalid name');
        update('users', ['name' => $name], 'id = ?', [$userId]);
        $_SESSION['user_name'] = $name;
        jsonResponse(true, 'Name updated successfully');
        break;
    
    case 'change_password':
        $current = $_POST['current_password'] ?? '';
        $newPass = $_POST['new_password'] ?? '';
        $confirm = $_POST['confirm_password'] ?? '';
        
        $user = getUserById($userId);
        if (!password_verify($current, $user['password'])) jsonResponse(false, 'Current password is incorrect');
        if (!validatePassword($newPass)) jsonResponse(false, 'New password must be 6-50 characters');
        if ($newPass !== $confirm) jsonResponse(false, 'Passwords do not match');
        
        $hash = password_hash($newPass, PASSWORD_BCRYPT);
        update('users', ['password' => $hash], 'id = ?', [$userId]);
        jsonResponse(true, 'Password changed successfully');
        break;
    
    case 'set_pin':
        $pin = $_POST['pin'] ?? '';
        if (!preg_match('/^\d{4}$/', $pin)) jsonResponse(false, 'PIN must be exactly 4 digits');
        
        $user = getUserById($userId);
        if (!empty($user['transaction_pin'])) jsonResponse(false, 'PIN already set. Contact support to reset.');
        
        $hash = password_hash($pin, PASSWORD_BCRYPT);
        update('users', ['transaction_pin' => $hash], 'id = ?', [$userId]);
        addNotification($userId, '🔒 Transaction PIN Set', 'Your 4-digit transaction PIN has been set.', 'system');
        jsonResponse(true, 'Transaction PIN set successfully');
        break;
    
    case 'verify_pin':
        $pin = $_POST['pin'] ?? '';
        $user = getUserById($userId);
        if (empty($user['transaction_pin'])) jsonResponse(false, 'No PIN set');
        if (!password_verify($pin, $user['transaction_pin'])) jsonResponse(false, 'Incorrect PIN');
        jsonResponse(true, 'PIN verified');
        break;
    
    case 'logout':
        logoutUser();
        jsonResponse(true, 'Logged out', ['redirect' => '/login.php']);
        break;
    
    default:
        jsonResponse(false, 'Invalid action');
}