<?php
/**
 * Notifications API
 */
require_once __DIR__ . '/../config.php';
requireLogin();

$userId = getCurrentUserId();
$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'get':
        $page = max(1, intval($_GET['page'] ?? 1));
        $limit = 20;
        $offset = ($page - 1) * $limit;
        $notifications = getUserNotifications($userId, $limit, $offset);
        $unread = getUnreadCount($userId);
        jsonResponse(true, '', ['notifications' => $notifications, 'unread' => $unread]);
        break;
    
    case 'read':
        $csrf = $_POST['csrf_token'] ?? '';
        if (!verifyCSRFToken($csrf)) jsonResponse(false, 'Invalid token');
        $id = intval($_POST['id'] ?? 0);
        if ($id > 0) {
            markAsRead($id, $userId);
        }
        jsonResponse(true, 'Marked as read');
        break;
    
    case 'read_all':
        $csrf = $_POST['csrf_token'] ?? '';
        if (!verifyCSRFToken($csrf)) jsonResponse(false, 'Invalid token');
        markAllAsRead($userId);
        jsonResponse(true, 'All marked as read');
        break;
    
    case 'count':
        jsonResponse(true, '', ['unread' => getUnreadCount($userId)]);
        break;
    
    default:
        jsonResponse(false, 'Invalid action');
}