<?php
/**
 * Fake Feed API — Returns random winning/withdrawal notifications
 */
require_once __DIR__ . '/../config.php';

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache');

$count = min(10, max(1, intval($_GET['count'] ?? 5)));
$feeds = [];

for ($i = 0; $i < $count; $i++) {
    $feeds[] = generateFakeFeed();
}

echo json_encode([
    'success' => true,
    'data'    => [
        'feeds'       => $feeds,
        'online_users'=> getFakeOnlineUsers(),
        'timestamp'   => time(),
    ]
], JSON_UNESCAPED_UNICODE);