<?php
/**
 * Bank Details API
 */
require_once __DIR__ . '/../config.php';
requireLogin();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') jsonResponse(false, 'Invalid method');
$csrf = $_POST['csrf_token'] ?? '';
if (!verifyCSRFToken($csrf)) jsonResponse(false, 'Invalid token');

$userId = getCurrentUserId();
$action = sanitize($_POST['action'] ?? '');

switch ($action) {
    case 'add_upi':
        $upiId = sanitize(trim($_POST['upi_id'] ?? ''));
        if (!validateUPI($upiId)) jsonResponse(false, 'Invalid UPI ID format (e.g., name@upi)');
        
        // Check duplicates
        $exists = fetch("SELECT * FROM `user_bank_details` WHERE `user_id`=? AND `type`='upi' AND `upi_id`=?", [$userId, $upiId]);
        if ($exists) jsonResponse(false, 'This UPI ID is already added');
        
        // Check limit
        $count = (int)(fetch("SELECT COUNT(*) as c FROM `user_bank_details` WHERE `user_id`=? AND `type`='upi'", [$userId])['c'] ?? 0);
        if ($count >= 3) jsonResponse(false, 'Maximum 3 UPI IDs allowed');
        
        $isPrimary = $count === 0 ? 1 : 0;
        insert('user_bank_details', ['user_id'=>$userId,'type'=>'upi','upi_id'=>$upiId,'is_primary'=>$isPrimary]);
        jsonResponse(true, 'UPI ID added successfully');
        break;
    
    case 'add_bank':
        $bankName = sanitize(trim($_POST['bank_name'] ?? ''));
        $accNum = preg_replace('/[^0-9]/', '', $_POST['account_number'] ?? '');
        $ifsc = strtoupper(sanitize(trim($_POST['ifsc_code'] ?? '')));
        $holder = sanitize(trim($_POST['account_holder'] ?? ''));
        
        if (empty($bankName)) jsonResponse(false, 'Bank name required');
        if (!validateAccountNumber($accNum)) jsonResponse(false, 'Invalid account number');
        if (!validateIFSC($ifsc)) jsonResponse(false, 'Invalid IFSC code');
        if (strlen($holder) < 2) jsonResponse(false, 'Account holder name required');
        
        $count = (int)(fetch("SELECT COUNT(*) as c FROM `user_bank_details` WHERE `user_id`=? AND `type`='bank'", [$userId])['c'] ?? 0);
        if ($count >= 2) jsonResponse(false, 'Maximum 2 bank accounts allowed');
        
        $isPrimary = $count === 0 ? 1 : 0;
        insert('user_bank_details', [
            'user_id'=>$userId,'type'=>'bank','bank_name'=>$bankName,
            'account_number'=>$accNum,'ifsc_code'=>$ifsc,'account_holder'=>$holder,'is_primary'=>$isPrimary
        ]);
        jsonResponse(true, 'Bank account added successfully');
        break;
    
    case 'set_primary':
        $id = intval($_POST['detail_id'] ?? 0);
        $detail = fetch("SELECT * FROM `user_bank_details` WHERE `id`=? AND `user_id`=?", [$id, $userId]);
        if (!$detail) jsonResponse(false, 'Not found');
        
        // Set all same type to non-primary
        query("UPDATE `user_bank_details` SET `is_primary`=0 WHERE `user_id`=? AND `type`=?", [$userId, $detail['type']]);
        update('user_bank_details', ['is_primary'=>1], 'id=?', [$id]);
        jsonResponse(true, 'Set as primary');
        break;
    
    case 'delete':
        $id = intval($_POST['detail_id'] ?? 0);
        $detail = fetch("SELECT * FROM `user_bank_details` WHERE `id`=? AND `user_id`=?", [$id, $userId]);
        if (!$detail) jsonResponse(false, 'Not found');
        
        // Check if locked
        if (!empty($detail['locked_until']) && strtotime($detail['locked_until']) > time()) {
            jsonResponse(false, 'This payment method is locked and cannot be deleted');
        }
        
        deleteRow('user_bank_details', 'id=? AND user_id=?', [$id, $userId]);
        jsonResponse(true, 'Deleted successfully');
        break;
    
    default:
        jsonResponse(false, 'Invalid action');
}