<?php
/**
 * Auth API — Registration & Login via AJAX
 * Not used currently (forms are server-side POST)
 * But available for future AJAX auth
 */
require_once __DIR__ . '/../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(false, 'Invalid method');
}

$action = sanitize($_POST['action'] ?? '');

switch ($action) {
    case 'logout':
        logoutUser();
        jsonResponse(true, 'Logged out', ['redirect' => '/login.php']);
        break;
    
    case 'check_session':
        jsonResponse(isLoggedIn(), isLoggedIn() ? 'Active' : 'Not logged in');
        break;
    
    default:
        jsonResponse(false, 'Invalid action');
}