<?php
define('ADMIN_PAGE', 'withdrawals');
define('ADMIN_TITLE', 'Manage Withdrawals');
require_once __DIR__ . '/includes/admin-check.php';

$status = sanitize($_GET['status'] ?? 'pending');
$page = max(1, intval($_GET['page'] ?? 1));
$perPage = 20;
$offset = ($page - 1) * $perPage;

$where = "1=1";
$params = [];
if (in_array($status, ['pending','processing','completed','rejected'])) {
    $where .= " AND w.`status` = ?";
    $params[] = $status;
}

$total = (int)(fetch("SELECT COUNT(*) as c FROM `withdrawals` w WHERE $where", $params)['c'] ?? 0);
$totalPages = max(1, ceil($total / $perPage));
$withdrawals = fetchAll("SELECT w.*, u.`name`, u.`phone`, u.`total_deposited` FROM `withdrawals` w JOIN `users` u ON w.`user_id`=u.`id` WHERE $where ORDER BY w.`created_at` DESC LIMIT $perPage OFFSET $offset", $params);

require_once __DIR__ . '/includes/admin-header.php';
?>

<div class="admin-tabs">
    <a href="?status=pending" class="admin-tab <?php echo $status==='pending'?'active':''; ?>">Pending <span class="admin-tab-badge"><?php echo (int)(fetch("SELECT COUNT(*) as c FROM `withdrawals` WHERE `status`='pending'")['c']??0); ?></span></a>
    <a href="?status=processing" class="admin-tab <?php echo $status==='processing'?'active':''; ?>">Processing</a>
    <a href="?status=completed" class="admin-tab <?php echo $status==='completed'?'active':''; ?>">Completed</a>
    <a href="?status=rejected" class="admin-tab <?php echo $status==='rejected'?'active':''; ?>">Rejected</a>
</div>

<div class="admin-card">
    <div class="admin-table-wrap">
        <table class="admin-table">
            <thead>
                <tr><th>ID</th><th>User</th><th>Amount</th><th>Method</th><th>Details</th><th>Status</th><th>Time</th><th>Actions</th></tr>
            </thead>
            <tbody>
                <?php foreach ($withdrawals as $w): ?>
                <tr>
                    <td>#<?php echo $w['id']; ?></td>
                    <td>
                        <a href="/admin/user-detail.php?id=<?php echo $w['user_id']; ?>" style="color:#FFD700"><?php echo htmlspecialchars($w['name']); ?></a>
                        <br><span style="font-size:10px;color:#888">Dep: ₹<?php echo number_format((float)$w['total_deposited']); ?></span>
                    </td>
                    <td class="text-red" style="font-weight:700">₹<?php echo number_format((float)$w['amount']); ?></td>
                    <td><?php echo strtoupper($w['payment_method']); ?></td>
                    <td style="font-size:11px">
                        <?php if ($w['payment_method'] === 'upi'): ?>
                        UPI: <?php echo htmlspecialchars($w['upi_id']); ?>
                        <?php else: ?>
                        <?php echo htmlspecialchars($w['bank_name']); ?><br>
                        A/C: ****<?php echo substr($w['account_number'],-4); ?> · IFSC: <?php echo $w['ifsc_code']; ?>
                        <?php endif; ?>
                    </td>
                    <td><span class="admin-badge <?php echo $w['status']==='pending'?'badge-warning':($w['status']==='completed'?'badge-success':($w['status']==='rejected'?'badge-danger':'badge-info')); ?>"><?php echo ucfirst($w['status']); ?></span></td>
                    <td style="font-size:11px"><?php echo timeAgo($w['created_at']); ?></td>
                    <td>
                        <?php if ($w['status'] === 'pending'): ?>
                        <button onclick="approveWd(<?php echo $w['id']; ?>)" class="admin-btn admin-btn-sm admin-btn-success" title="Approve"><i class="fas fa-check"></i></button>
                        <button onclick="rejectWd(<?php echo $w['id']; ?>)" class="admin-btn admin-btn-sm admin-btn-danger" title="Reject"><i class="fas fa-times"></i></button>
                        <?php elseif ($w['status'] === 'processing'): ?>
                        <button onclick="completeWd(<?php echo $w['id']; ?>)" class="admin-btn admin-btn-sm admin-btn-success" title="Mark Complete"><i class="fas fa-check-double"></i></button>
                        <?php else: ?>—<?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php if ($totalPages > 1): ?>
    <div class="admin-pagination">
        <?php for ($p = max(1,$page-3); $p <= min($totalPages,$page+3); $p++): ?>
        <a href="?status=<?php echo $status; ?>&page=<?php echo $p; ?>" class="admin-page-btn <?php echo $p===$page?'active':''; ?>"><?php echo $p; ?></a>
        <?php endfor; ?>
    </div>
    <?php endif; ?>
</div>

<script>
function approveWd(id){adminConfirm('Approve?','Mark as processing?','Approve',function(){adminAjax('/admin/api/finance.php',{action:'approve_withdrawal',withdrawal_id:id},function(r){if(r.success){adminToast('Approved');location.reload();}else adminError(r.message);});});}
function completeWd(id){adminConfirm('Complete?','Mark as completed?','Complete',function(){adminAjax('/admin/api/finance.php',{action:'complete_withdrawal',withdrawal_id:id},function(r){if(r.success){adminToast('Completed');location.reload();}else adminError(r.message);});});}
function rejectWd(id){Swal.fire({title:'Reject',input:'text',inputPlaceholder:'Reason',showCancelButton:true,background:'#1f2940',color:'#fff',confirmButtonColor:'#ef4444',confirmButtonText:'Reject'}).then(function(r){if(r.isConfirmed){adminAjax('/admin/api/finance.php',{action:'reject_withdrawal',withdrawal_id:id,reason:r.value||'Rejected'},function(res){if(res.success){adminToast('Rejected');location.reload();}else adminError(res.message);});}});}
</script>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>