<?php
define('ADMIN_PAGE', 'wingo');
define('ADMIN_TITLE', 'Wingo Control');
require_once __DIR__ . '/includes/admin-check.php';

$durations = [1,3,5,10];
$periods = [];
foreach ($durations as $d) {
    $periods[$d] = getCurrentWingoPeriod($d);
}

$recentResults = fetchAll("SELECT * FROM `wingo_periods` WHERE `status`='resulted' ORDER BY `end_time` DESC LIMIT 30");
$todayProfit = (float)(fetch("SELECT COALESCE(SUM(`site_profit`),0) as t FROM `wingo_periods` WHERE `status`='resulted' AND DATE(`created_at`)=CURDATE()")['t'] ?? 0);

require_once __DIR__ . '/includes/admin-header.php';
?>

<!-- Stats -->
<div class="stat-grid" style="grid-template-columns:repeat(3,1fr)">
    <div class="stat-card sc-gold"><div class="sc-info"><div class="sc-value <?php echo $todayProfit>=0?'text-green':'text-red'; ?>">₹<?php echo number_format($todayProfit); ?></div><div class="sc-label">Today's Wingo Profit</div></div></div>
    <div class="stat-card sc-blue"><div class="sc-info"><div class="sc-value"><?php echo getAlgorithmSetting('algorithm_mode', 'smart'); ?></div><div class="sc-label">Algorithm Mode</div></div></div>
    <div class="stat-card sc-purple"><div class="sc-info"><div class="sc-value"><?php echo (int)(fetch("SELECT COUNT(*) as c FROM `wingo_bets` WHERE DATE(`created_at`)=CURDATE()")['c']??0); ?></div><div class="sc-label">Today's Bets</div></div></div>
</div>

<!-- Active Periods + Manual Result -->
<div class="admin-card" style="margin-top:16px">
    <div class="ac-header"><h3>🎯 Set Manual Result</h3></div>
    <div class="ac-body">
        <?php foreach ($durations as $d):
            $p = $periods[$d];
        ?>
        <div style="display:flex;align-items:center;gap:10px;padding:10px;border-bottom:1px solid rgba(255,255,255,.06)">
            <div style="width:60px;font-size:14px;font-weight:700;color:var(--primary)"><?php echo $d; ?>min</div>
            <div style="flex:1;font-size:11px;color:#888">Period: <?php echo $p['period_number']; ?><br>Ends: <?php echo $p['end_time']; ?></div>
            <select id="manualNum_<?php echo $d; ?>" class="admin-select" style="width:60px">
                <option value="">-</option>
                <?php for($i=0;$i<=9;$i++): ?><option value="<?php echo $i; ?>"><?php echo $i; ?></option><?php endfor; ?>
            </select>
            <button onclick="setManualResult(<?php echo $d; ?>,'<?php echo $p['period_number']; ?>')" class="admin-btn admin-btn-primary admin-btn-sm">Set</button>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- Recent Results -->
<div class="admin-card" style="margin-top:16px">
    <div class="ac-header"><h3>Recent Results</h3></div>
    <div class="admin-table-wrap">
        <table class="admin-table">
            <thead><tr><th>Period</th><th>Duration</th><th>Result</th><th>Bets</th><th>Payout</th><th>Profit</th><th>Time</th></tr></thead>
            <tbody>
            <?php foreach ($recentResults as $r):
                $profitClass = (float)$r['site_profit'] >= 0 ? 'text-green' : 'text-red';
            ?>
            <tr>
                <td style="font-family:monospace;font-size:11px"><?php echo substr($r['period_number'],-8); ?></td>
                <td><?php echo $r['game_duration']; ?>m</td>
                <td>
                    <?php $c=getColorFromNumber((int)$r['result_number']); $bg=str_contains($c,'green')?'#00C853':'#FF4444'; ?>
                    <span style="display:inline-flex;align-items:center;justify-content:center;width:24px;height:24px;border-radius:50%;background:<?php echo $bg; ?>;color:#fff;font-weight:700;font-size:11px"><?php echo $r['result_number']; ?></span>
                </td>
                <td>₹<?php echo number_format((float)$r['total_bet_amount']); ?></td>
                <td>₹<?php echo number_format((float)$r['total_payout']); ?></td>
                <td class="<?php echo $profitClass; ?>" style="font-weight:700">₹<?php echo number_format((float)$r['site_profit']); ?></td>
                <td style="font-size:11px"><?php echo timeAgo($r['created_at']); ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function setManualResult(duration, periodNumber) {
    var num = document.getElementById('manualNum_' + duration).value;
    if (num === '') { adminError('Select a number'); return; }
    adminConfirm('Set Result?', 'Set number ' + num + ' for ' + duration + 'min period?', 'Set', function() {
        adminAjax('/admin/api/games.php', {action:'set_manual_result', game_duration:duration, period_number:periodNumber, result_number:num}, function(r) {
            if(r.success) adminToast('Manual result set!');
            else adminError(r.message);
        });
    });
}
</script>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>