<?php
define('ADMIN_PAGE', 'users');
define('ADMIN_TITLE', 'Manage Users');
require_once __DIR__ . '/includes/admin-check.php';

$search = sanitize($_GET['search'] ?? '');
$status = sanitize($_GET['status'] ?? '');
$page = max(1, intval($_GET['page'] ?? 1));
$perPage = 20;
$offset = ($page - 1) * $perPage;

$where = '1=1';
$params = [];

if (!empty($search)) {
    $where .= " AND (u.`name` LIKE ? OR u.`phone` LIKE ? OR u.`id` = ? OR u.`referral_code` LIKE ?)";
    $params = array_merge($params, ["%$search%", "%$search%", (int)$search, "%$search%"]);
}
if (!empty($status) && in_array($status, ['active', 'banned'])) {
    $where .= " AND u.`status` = ?";
    $params[] = $status;
}

$total = (int)(fetch("SELECT COUNT(*) as c FROM `users` u WHERE $where", $params)['c'] ?? 0);
$totalPages = max(1, ceil($total / $perPage));
$users = fetchAll("SELECT u.*, w.`main_balance`, w.`bonus_balance` FROM `users` u LEFT JOIN `wallets` w ON u.`id`=w.`user_id` WHERE $where ORDER BY u.`id` DESC LIMIT $perPage OFFSET $offset", $params);

require_once __DIR__ . '/includes/admin-header.php';
?>

<!-- Search -->
<div class="admin-card" style="margin-bottom:16px">
    <form method="GET" class="admin-search-form">
        <input type="text" name="search" placeholder="Search by name, phone, ID, referral code..." value="<?php echo htmlspecialchars($search); ?>" class="admin-input" style="flex:1">
        <select name="status" class="admin-select">
            <option value="">All Status</option>
            <option value="active" <?php echo $status==='active'?'selected':''; ?>>Active</option>
            <option value="banned" <?php echo $status==='banned'?'selected':''; ?>>Banned</option>
        </select>
        <button type="submit" class="admin-btn admin-btn-primary"><i class="fas fa-search"></i> Search</button>
    </form>
</div>

<!-- Users Table -->
<div class="admin-card">
    <div class="ac-header">
        <h3>Users (<?php echo number_format($total); ?>)</h3>
    </div>
    <div class="admin-table-wrap">
        <table class="admin-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Phone</th>
                    <th>Balance</th>
                    <th>Deposited</th>
                    <th>VIP</th>
                    <th>Status</th>
                    <th>Joined</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $u): ?>
                <tr>
                    <td>#<?php echo $u['id']; ?></td>
                    <td><?php echo htmlspecialchars($u['name']); ?></td>
                    <td><?php echo $u['phone']; ?></td>
                    <td>
                        <span class="text-green">₹<?php echo number_format((float)($u['main_balance']??0), 2); ?></span>
                        <br><span style="font-size:10px;color:#888">+₹<?php echo number_format((float)($u['bonus_balance']??0), 2); ?> bonus</span>
                    </td>
                    <td>₹<?php echo number_format((float)$u['total_deposited']); ?></td>
                    <td><span class="admin-badge badge-vip">VIP <?php echo $u['vip_level']; ?></span></td>
                    <td>
                        <span class="admin-badge <?php echo $u['status']==='active'?'badge-success':'badge-danger'; ?>">
                            <?php echo ucfirst($u['status']); ?>
                        </span>
                    </td>
                    <td><?php echo formatDate($u['created_at'], 'd M Y'); ?></td>
                    <td>
                        <a href="/admin/user-detail.php?id=<?php echo $u['id']; ?>" class="admin-btn admin-btn-sm"><i class="fas fa-eye"></i></a>
                        <?php if ($u['status'] === 'active'): ?>
                        <button onclick="banUser(<?php echo $u['id']; ?>,'<?php echo addslashes($u['name']); ?>')" class="admin-btn admin-btn-sm admin-btn-danger"><i class="fas fa-ban"></i></button>
                        <?php else: ?>
                        <button onclick="unbanUser(<?php echo $u['id']; ?>)" class="admin-btn admin-btn-sm admin-btn-success"><i class="fas fa-check"></i></button>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    <?php if ($totalPages > 1): ?>
    <div class="admin-pagination">
        <?php for ($p = max(1,$page-3); $p <= min($totalPages,$page+3); $p++): ?>
        <a href="?search=<?php echo urlencode($search); ?>&status=<?php echo $status; ?>&page=<?php echo $p; ?>" class="admin-page-btn <?php echo $p===$page?'active':''; ?>"><?php echo $p; ?></a>
        <?php endfor; ?>
    </div>
    <?php endif; ?>
</div>

<script>
function banUser(id, name) {
    adminConfirm('Ban User?', 'Ban "' + name + '"? They won\'t be able to login.', 'Ban', function() {
        adminAjax('/admin/api/users.php', {action:'ban_user', user_id:id}, function(r) {
            if(r.success) { adminToast('User banned'); location.reload(); }
            else adminError(r.message);
        });
    });
}
function unbanUser(id) {
    adminAjax('/admin/api/users.php', {action:'unban_user', user_id:id}, function(r) {
        if(r.success) { adminToast('User unbanned'); location.reload(); }
        else adminError(r.message);
    });
}
</script>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>