<?php
define('ADMIN_PAGE', 'users');
define('ADMIN_TITLE', 'User Detail');
require_once __DIR__ . '/includes/admin-check.php';

$userId = intval($_GET['id'] ?? 0);
$user = getUserById($userId);
if (!$user) { redirect('/admin/users.php'); }

$wallet = getWallet($userId);
$vipInfo = getVIPBenefits((int)$user['vip_level']);
$algoData = fetch("SELECT * FROM `user_algorithm_data` WHERE `user_id`=?", [$userId]);
$refCount = getReferralCount($userId);
$refEarnings = getReferralEarnings($userId);
$bankDetails = fetchAll("SELECT * FROM `user_bank_details` WHERE `user_id`=? ORDER BY `type`, `is_primary` DESC", [$userId]);
$recentTx = fetchAll("SELECT * FROM `transactions` WHERE `user_id`=? ORDER BY `created_at` DESC LIMIT 20", [$userId]);
$recentDeposits = fetchAll("SELECT * FROM `deposits` WHERE `user_id`=? ORDER BY `created_at` DESC LIMIT 10", [$userId]);
$recentWd = fetchAll("SELECT * FROM `withdrawals` WHERE `user_id`=? ORDER BY `created_at` DESC LIMIT 10", [$userId]);

require_once __DIR__ . '/includes/admin-header.php';
?>

<a href="/admin/users.php" class="admin-back-link"><i class="fas fa-arrow-left"></i> Back to Users</a>

<!-- User Header -->
<div class="admin-card" style="margin-bottom:16px">
    <div style="display:flex;align-items:center;gap:14px;padding:4px 0">
        <div style="width:50px;height:50px;border-radius:50%;background:<?php echo $vipInfo['color']??'#888'; ?>20;color:<?php echo $vipInfo['color']??'#888'; ?>;display:flex;align-items:center;justify-content:center;font-size:20px;font-weight:700"><?php echo strtoupper(substr($user['name'],0,1)); ?></div>
        <div style="flex:1">
            <div style="font-size:18px;font-weight:700;color:#fff"><?php echo htmlspecialchars($user['name']); ?> <span class="admin-badge badge-vip">VIP <?php echo $user['vip_level']; ?></span> <span class="admin-badge <?php echo $user['status']==='active'?'badge-success':'badge-danger'; ?>"><?php echo ucfirst($user['status']); ?></span></div>
            <div style="font-size:12px;color:#888">#<?php echo $user['id']; ?> · <?php echo $user['phone']; ?> · <?php echo $user['referral_code']; ?></div>
            <div style="font-size:10px;color:#666">Joined: <?php echo formatDate($user['created_at']); ?> · Last login: <?php echo $user['last_login'] ? timeAgo($user['last_login']) : 'Never'; ?></div>
        </div>
        <div style="display:flex;gap:6px">
            <button onclick="addBalance(<?php echo $userId; ?>)" class="admin-btn admin-btn-success admin-btn-sm"><i class="fas fa-plus"></i> Add ₹</button>
            <button onclick="deductBalance(<?php echo $userId; ?>)" class="admin-btn admin-btn-danger admin-btn-sm"><i class="fas fa-minus"></i> Deduct ₹</button>
            <button onclick="changePhase(<?php echo $userId; ?>,<?php echo $algoData['current_phase']??2; ?>)" class="admin-btn admin-btn-sm"><i class="fas fa-brain"></i> Phase</button>
        </div>
    </div>
</div>

<!-- Stats -->
<div class="stat-grid" style="grid-template-columns:repeat(6,1fr)">
    <div class="stat-card sc-green" style="padding:12px"><div class="sc-info"><div class="sc-value" style="font-size:14px">₹<?php echo number_format((float)$wallet['main_balance'],2); ?></div><div class="sc-label" style="font-size:9px">Main Balance</div></div></div>
    <div class="stat-card sc-blue" style="padding:12px"><div class="sc-info"><div class="sc-value" style="font-size:14px">₹<?php echo number_format((float)$wallet['bonus_balance'],2); ?></div><div class="sc-label" style="font-size:9px">Bonus</div></div></div>
    <div class="stat-card sc-gold" style="padding:12px"><div class="sc-info"><div class="sc-value" style="font-size:14px">₹<?php echo number_format((float)$user['total_deposited']); ?></div><div class="sc-label" style="font-size:9px">Deposited</div></div></div>
    <div class="stat-card sc-red" style="padding:12px"><div class="sc-info"><div class="sc-value" style="font-size:14px">₹<?php echo number_format((float)$user['total_withdrawn']); ?></div><div class="sc-label" style="font-size:9px">Withdrawn</div></div></div>
    <div class="stat-card sc-purple" style="padding:12px"><div class="sc-info"><div class="sc-value" style="font-size:14px">₹<?php echo number_format((float)$user['total_bet']); ?></div><div class="sc-label" style="font-size:9px">Total Bet</div></div></div>
    <div class="stat-card sc-orange" style="padding:12px"><div class="sc-info"><div class="sc-value" style="font-size:14px">Phase <?php echo $algoData['current_phase']??'?'; ?></div><div class="sc-label" style="font-size:9px">Algorithm</div></div></div>
</div>

<!-- Recent Transactions -->
<div class="admin-card" style="margin-top:16px">
    <div class="ac-header"><h3>Recent Transactions</h3></div>
    <div class="admin-table-wrap">
        <table class="admin-table">
            <thead><tr><th>Type</th><th>Amount</th><th>Wallet</th><th>Description</th><th>Time</th></tr></thead>
            <tbody>
            <?php foreach ($recentTx as $tx):
                $isCredit = in_array($tx['type'], ['deposit','win','bonus','referral_commission','checkin_bonus','admin_add','spin_reward','mine_cashout','gift_code']);
            ?>
            <tr>
                <td><?php echo ucwords(str_replace('_',' ',$tx['type'])); ?></td>
                <td class="<?php echo $isCredit?'text-green':'text-red'; ?>"><?php echo $isCredit?'+':'-'; ?>₹<?php echo number_format((float)$tx['amount'],2); ?></td>
                <td><?php echo $tx['wallet_type']; ?></td>
                <td style="font-size:11px"><?php echo htmlspecialchars(substr($tx['description']??'',0,60)); ?></td>
                <td style="font-size:11px"><?php echo timeAgo($tx['created_at']); ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function addBalance(uid){
    Swal.fire({title:'Add Balance',html:'<input id="add-amt" type="number" class="swal2-input" placeholder="Amount" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c"><select id="add-wallet" class="swal2-input" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c"><option value="main">Main</option><option value="bonus">Bonus</option></select><input id="add-reason" class="swal2-input" placeholder="Reason" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c">',showCancelButton:true,background:'#1f2940',color:'#fff',confirmButtonColor:'#22c55e',confirmButtonText:'Add'}).then(function(r){
        if(r.isConfirmed){
            adminAjax('/admin/api/users.php',{action:'add_balance',user_id:uid,amount:document.getElementById('add-amt').value,wallet:document.getElementById('add-wallet').value,reason:document.getElementById('add-reason').value},function(res){
                if(res.success){adminToast('Balance added');location.reload();}else adminError(res.message);
            });
        }
    });
}
function deductBalance(uid){
    Swal.fire({title:'Deduct Balance',html:'<input id="ded-amt" type="number" class="swal2-input" placeholder="Amount" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c"><select id="ded-wallet" class="swal2-input" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c"><option value="main">Main</option><option value="bonus">Bonus</option></select><input id="ded-reason" class="swal2-input" placeholder="Reason" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c">',showCancelButton:true,background:'#1f2940',color:'#fff',confirmButtonColor:'#ef4444',confirmButtonText:'Deduct'}).then(function(r){
        if(r.isConfirmed){
            adminAjax('/admin/api/users.php',{action:'deduct_balance',user_id:uid,amount:document.getElementById('ded-amt').value,wallet:document.getElementById('ded-wallet').value,reason:document.getElementById('ded-reason').value},function(res){
                if(res.success){adminToast('Balance deducted');location.reload();}else adminError(res.message);
            });
        }
    });
}
function changePhase(uid,current){
    Swal.fire({title:'Change Algorithm Phase',input:'select',inputOptions:{1:'Phase 1 — HOOK (65%)',2:'Phase 2 — NORMAL (40%)',3:'Phase 3 — TRAP (20%)',4:'Phase 4 — MILK (8%)'},inputValue:current,showCancelButton:true,background:'#1f2940',color:'#fff',confirmButtonColor:'#FFD700'}).then(function(r){
        if(r.isConfirmed){
            adminAjax('/admin/api/users.php',{action:'set_phase',user_id:uid,phase:r.value},function(res){
                if(res.success){adminToast('Phase updated');location.reload();}else adminError(res.message);
            });
        }
    });
}
</script>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>