<?php
define('ADMIN_PAGE', 'upi');
define('ADMIN_TITLE', 'UPI Settings');
require_once __DIR__ . '/includes/admin-check.php';

$upiList = fetchAll("SELECT * FROM `admin_upi_settings` ORDER BY `priority` DESC, `id` ASC");
$collectionMode = getSetting('upi_collection_mode', 'multi');

require_once __DIR__ . '/includes/admin-header.php';
?>

<style>
.upi-mode-toggle{display:flex;gap:10px;margin-bottom:20px}
.mode-btn{flex:1;padding:14px;border-radius:12px;border:2px solid rgba(255,255,255,.08);background:rgba(255,255,255,.03);color:#94a3b8;font-size:13px;font-weight:600;cursor:pointer;text-align:center;transition:.2s;font-family:'Poppins',sans-serif}
.mode-btn.active{border-color:var(--admin-primary);background:rgba(255,215,0,.06);color:var(--admin-primary)}
.mode-btn .mode-icon{font-size:22px;display:block;margin-bottom:6px}
.upi-card{background:rgba(255,255,255,.03);border:1px solid rgba(255,255,255,.06);border-radius:12px;padding:16px;margin-bottom:12px;transition:.2s}
.upi-card.inactive{opacity:.5}
.upi-card-top{display:flex;align-items:center;gap:12px}
.upi-avatar{width:44px;height:44px;border-radius:10px;background:linear-gradient(135deg,#FFD700,#FFA000);display:flex;align-items:center;justify-content:center;font-size:18px;flex-shrink:0}
.upi-info{flex:1}
.upi-id-text{font-size:14px;font-weight:700;color:#fff}
.upi-name-text{font-size:11px;color:#64748b;margin-top:2px}
.upi-badges{display:flex;gap:6px;margin-top:4px}
.upi-actions{display:flex;gap:6px}
.qr-preview{width:80px;height:80px;border-radius:8px;object-fit:cover;border:2px solid rgba(255,215,0,.2)}
.qr-placeholder{width:80px;height:80px;border-radius:8px;border:2px dashed rgba(255,255,255,.1);display:flex;align-items:center;justify-content:center;color:#475569;font-size:22px;cursor:pointer}
.upi-limits{display:grid;grid-template-columns:repeat(3,1fr);gap:8px;margin-top:12px;padding-top:12px;border-top:1px solid rgba(255,255,255,.05)}
.limit-item{text-align:center}
.limit-val{font-size:13px;font-weight:700;color:#fff}
.limit-lbl{font-size:9px;color:#475569}
.add-upi-form{background:rgba(255,215,0,.03);border:1px dashed rgba(255,215,0,.2);border-radius:12px;padding:18px;margin-top:16px}
.form-row{display:grid;grid-template-columns:1fr 1fr;gap:12px;margin-bottom:12px}
.form-group label{display:block;font-size:11px;font-weight:600;color:#94a3b8;margin-bottom:5px}
.priority-badge{background:rgba(255,215,0,.1);color:#FFD700;font-size:9px;font-weight:700;padding:2px 6px;border-radius:4px}
</style>

<div class="admin-card" style="margin-bottom:16px">
    <div class="ac-header">
        <h3>💳 UPI Collection Mode</h3>
    </div>
    <div class="ac-body">
        <p style="font-size:12px;color:#64748b;margin-bottom:14px">Choose how deposits are collected. <b style="color:#fff">Single</b> = ek hi UPI dikhega. <b style="color:#fff">Multi</b> = saare active UPIs rotate honge.</p>
        <div class="upi-mode-toggle">
            <button class="mode-btn <?php echo $collectionMode==='single'?'active':''; ?>" onclick="setMode('single')">
                <span class="mode-icon">🎯</span>
                Single UPI Mode
                <div style="font-size:10px;font-weight:400;margin-top:4px;color:inherit">Ek fixed UPI pe sabka payment</div>
            </button>
            <button class="mode-btn <?php echo $collectionMode==='multi'?'active':''; ?>" onclick="setMode('multi')">
                <span class="mode-icon">🔄</span>
                Multi UPI Mode
                <div style="font-size:10px;font-weight:400;margin-top:4px;color:inherit">Load balance across multiple UPIs</div>
            </button>
        </div>
        <div id="modeHint" style="font-size:11px;padding:10px;border-radius:8px;background:rgba(59,130,246,.08);color:#93c5fd">
            <?php if($collectionMode==='single'): ?>
            ⚠️ Single mode: Sirf highest priority wala active UPI users ko dikhega.
            <?php else: ?>
            ✅ Multi mode: Saare active UPIs me se daily limit ke hisab se rotate hoga.
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="admin-card">
    <div class="ac-header">
        <h3>📱 UPI Accounts (<?php echo count($upiList); ?>)</h3>
        <button class="admin-btn admin-btn-primary admin-btn-sm" onclick="toggleAddForm()"><i class="fas fa-plus"></i> Add UPI</button>
    </div>
    <div class="ac-body">
        
        <?php if(empty($upiList)): ?>
        <div class="ac-empty">Koi UPI nahi hai. Pehla UPI add karo.</div>
        <?php endif; ?>
        
        <div id="upiList">
        <?php foreach($upiList as $u): ?>
        <div class="upi-card <?php echo !$u['is_active']?'inactive':''; ?>" id="upi-card-<?php echo $u['id']; ?>">
            <div class="upi-card-top">
                <div class="upi-avatar">💳</div>
                <div class="upi-info">
                    <div class="upi-id-text"><?php echo htmlspecialchars($u['upi_id']); ?></div>
                    <div class="upi-name-text"><?php echo htmlspecialchars($u['display_name']); ?></div>
                    <div class="upi-badges">
                        <span class="admin-badge <?php echo $u['is_active']?'badge-success':'badge-danger'; ?>"><?php echo $u['is_active']?'Active':'Inactive'; ?></span>
                        <span class="priority-badge">Priority: <?php echo $u['priority']; ?></span>
                    </div>
                </div>
                <?php if(!empty($u['qr_code_image'])): ?>
                <img src="/uploads/upi_qr/<?php echo htmlspecialchars($u['qr_code_image']); ?>" class="qr-preview" alt="QR">
                <?php else: ?>
                <div class="qr-placeholder" onclick="openQrUpload(<?php echo $u['id']; ?>)" title="Upload QR Code"><i class="fas fa-qrcode"></i></div>
                <?php endif; ?>
                <div class="upi-actions">
                    <button class="admin-btn admin-btn-sm" style="background:rgba(255,255,255,.06)" onclick="editUpi(<?php echo $u['id']; ?>)" title="Edit"><i class="fas fa-edit"></i></button>
                    <button class="admin-btn admin-btn-sm <?php echo $u['is_active']?'admin-btn-danger':'admin-btn-success'; ?>" onclick="toggleUpi(<?php echo $u['id']; ?>,<?php echo $u['is_active']?0:1; ?>)" title="<?php echo $u['is_active']?'Deactivate':'Activate'; ?>">
                        <i class="fas fa-<?php echo $u['is_active']?'ban':'check'; ?>"></i>
                    </button>
                    <button class="admin-btn admin-btn-sm admin-btn-danger" onclick="deleteUpi(<?php echo $u['id']; ?>)" title="Delete"><i class="fas fa-trash"></i></button>
                </div>
            </div>
            <div class="upi-limits">
                <div class="limit-item"><div class="limit-val">₹<?php echo number_format($u['min_amount']); ?></div><div class="limit-lbl">Min Amount</div></div>
                <div class="limit-item"><div class="limit-val">₹<?php echo number_format($u['max_amount']); ?></div><div class="limit-lbl">Max Amount</div></div>
                <div class="limit-item"><div class="limit-val">₹<?php echo number_format($u['daily_limit']); ?></div><div class="limit-lbl">Daily Limit</div></div>
            </div>
        </div>
        <?php endforeach; ?>
        </div>

        <!-- Add UPI Form -->
        <div class="add-upi-form" id="addUpiForm" style="display:none">
            <h4 style="font-size:13px;font-weight:700;color:#FFD700;margin-bottom:14px">➕ New UPI Account</h4>
            <div class="form-row">
                <div class="form-group">
                    <label>UPI ID *</label>
                    <input type="text" id="new_upi_id" class="admin-input" style="width:100%" placeholder="example@upi">
                </div>
                <div class="form-group">
                    <label>Display Name</label>
                    <input type="text" id="new_display_name" class="admin-input" style="width:100%" placeholder="Hindustan Club" value="Hindustan Club">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label>Min Amount (₹)</label>
                    <input type="number" id="new_min_amount" class="admin-input" style="width:100%" value="100">
                </div>
                <div class="form-group">
                    <label>Max Amount (₹)</label>
                    <input type="number" id="new_max_amount" class="admin-input" style="width:100%" value="50000">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label>Daily Limit (₹)</label>
                    <input type="number" id="new_daily_limit" class="admin-input" style="width:100%" value="500000">
                </div>
                <div class="form-group">
                    <label>Priority (higher = first)</label>
                    <input type="number" id="new_priority" class="admin-input" style="width:100%" value="0" min="0" max="100">
                </div>
            </div>
            <div style="margin-bottom:12px">
                <label style="font-size:11px;font-weight:600;color:#94a3b8;display:block;margin-bottom:5px">QR Code Image (optional)</label>
                <input type="file" id="new_qr_file" accept="image/*" style="font-size:12px;color:#94a3b8">
            </div>
            <div style="display:flex;gap:8px">
                <button class="admin-btn admin-btn-primary" onclick="addUpi()"><i class="fas fa-plus"></i> Add UPI</button>
                <button class="admin-btn" style="background:rgba(255,255,255,.06)" onclick="toggleAddForm()">Cancel</button>
            </div>
        </div>

        <!-- Hidden QR upload input -->
        <input type="file" id="qrUploadInput" accept="image/*" style="display:none" onchange="uploadQr(this)">
        <input type="hidden" id="qrUploadForId" value="">
    </div>
</div>

<!-- Edit Modal -->
<div id="editModal" style="display:none;position:fixed;inset:0;background:rgba(0,0,0,.7);z-index:1000;display:none;align-items:center;justify-content:center">
    <div style="background:#1e293b;border-radius:16px;padding:24px;width:480px;max-width:95vw;border:1px solid rgba(255,255,255,.1)">
        <h3 style="font-size:15px;font-weight:700;margin-bottom:16px">✏️ Edit UPI</h3>
        <input type="hidden" id="edit_id">
        <div class="form-row">
            <div class="form-group"><label>UPI ID</label><input type="text" id="edit_upi_id" class="admin-input" style="width:100%"></div>
            <div class="form-group"><label>Display Name</label><input type="text" id="edit_display_name" class="admin-input" style="width:100%"></div>
        </div>
        <div class="form-row">
            <div class="form-group"><label>Min Amount</label><input type="number" id="edit_min_amount" class="admin-input" style="width:100%"></div>
            <div class="form-group"><label>Max Amount</label><input type="number" id="edit_max_amount" class="admin-input" style="width:100%"></div>
        </div>
        <div class="form-row">
            <div class="form-group"><label>Daily Limit</label><input type="number" id="edit_daily_limit" class="admin-input" style="width:100%"></div>
            <div class="form-group"><label>Priority</label><input type="number" id="edit_priority" class="admin-input" style="width:100%" min="0" max="100"></div>
        </div>
        <div style="display:flex;gap:8px;margin-top:4px">
            <button class="admin-btn admin-btn-primary" onclick="saveEditUpi()"><i class="fas fa-save"></i> Save</button>
            <button class="admin-btn" style="background:rgba(255,255,255,.06)" onclick="closeEditModal()">Cancel</button>
        </div>
    </div>
</div>

<script>
var upiData = <?php echo json_encode($upiList); ?>;

function setMode(mode) {
    adminAjax('/admin/api/settings.php', {action:'update_settings', 'settings[upi_collection_mode]':mode}, function(r) {
        if(r.success) {
            document.querySelectorAll('.mode-btn').forEach(b => b.classList.remove('active'));
            event.target.closest('.mode-btn').classList.add('active');
            var hints = {single:'⚠️ Single mode: Sirf highest priority wala active UPI users ko dikhega.', multi:'✅ Multi mode: Saare active UPIs me se daily limit ke hisab se rotate hoga.'};
            document.getElementById('modeHint').innerHTML = hints[mode];
            adminToast('Mode updated to ' + mode.toUpperCase());
        } else adminError(r.message);
    });
}

function toggleAddForm() {
    var f = document.getElementById('addUpiForm');
    f.style.display = f.style.display === 'none' ? 'block' : 'none';
}

function addUpi() {
    var upiId = document.getElementById('new_upi_id').value.trim();
    if (!upiId) return adminError('UPI ID required');
    var formData = new FormData();
    formData.append('action','add_upi');
    formData.append('csrf_token', document.querySelector('meta[name=csrf-token]').content);
    formData.append('upi_id', upiId);
    formData.append('display_name', document.getElementById('new_display_name').value || 'Hindustan Club');
    formData.append('min_amount', document.getElementById('new_min_amount').value || 100);
    formData.append('max_amount', document.getElementById('new_max_amount').value || 50000);
    formData.append('daily_limit', document.getElementById('new_daily_limit').value || 500000);
    formData.append('priority', document.getElementById('new_priority').value || 0);
    var qrFile = document.getElementById('new_qr_file').files[0];
    if (qrFile) formData.append('qr_file', qrFile);
    
    fetch('/admin/api/settings.php', {method:'POST', body:formData})
        .then(r=>r.json()).then(r=>{
            if(r.success){ adminToast('UPI Added!'); setTimeout(()=>location.reload(),800); }
            else adminError(r.message);
        });
}

function toggleUpi(id, active) {
    adminAjax('/admin/api/settings.php', {action:'toggle_upi', upi_id_record:id, is_active:active}, function(r){
        if(r.success){ adminToast(active?'UPI Activated':'UPI Deactivated'); setTimeout(()=>location.reload(),600); }
        else adminError(r.message);
    });
}

function deleteUpi(id) {
    if(!confirm('Delete this UPI? Ye action undo nahi ho sakti.')) return;
    adminAjax('/admin/api/settings.php', {action:'delete_upi', upi_id_record:id}, function(r){
        if(r.success){ adminToast('Deleted'); document.getElementById('upi-card-'+id).remove(); }
        else adminError(r.message);
    });
}

function editUpi(id) {
    var u = upiData.find(x=>x.id==id);
    if (!u) return;
    document.getElementById('edit_id').value = u.id;
    document.getElementById('edit_upi_id').value = u.upi_id;
    document.getElementById('edit_display_name').value = u.display_name;
    document.getElementById('edit_min_amount').value = u.min_amount;
    document.getElementById('edit_max_amount').value = u.max_amount;
    document.getElementById('edit_daily_limit').value = u.daily_limit;
    document.getElementById('edit_priority').value = u.priority;
    document.getElementById('editModal').style.display = 'flex';
}

function closeEditModal() { document.getElementById('editModal').style.display = 'none'; }

function saveEditUpi() {
    var id = document.getElementById('edit_id').value;
    adminAjax('/admin/api/settings.php', {
        action:'edit_upi',
        upi_id_record: id,
        upi_id: document.getElementById('edit_upi_id').value,
        display_name: document.getElementById('edit_display_name').value,
        min_amount: document.getElementById('edit_min_amount').value,
        max_amount: document.getElementById('edit_max_amount').value,
        daily_limit: document.getElementById('edit_daily_limit').value,
        priority: document.getElementById('edit_priority').value,
    }, function(r){
        if(r.success){ adminToast('Updated!'); setTimeout(()=>location.reload(),600); }
        else adminError(r.message);
    });
}

function openQrUpload(id) {
    document.getElementById('qrUploadForId').value = id;
    document.getElementById('qrUploadInput').click();
}

function uploadQr(input) {
    var id = document.getElementById('qrUploadForId').value;
    var formData = new FormData();
    formData.append('action','upload_upi_qr');
    formData.append('csrf_token', document.querySelector('meta[name=csrf-token]').content);
    formData.append('upi_id_record', id);
    formData.append('qr_file', input.files[0]);
    fetch('/admin/api/settings.php', {method:'POST', body:formData})
        .then(r=>r.json()).then(r=>{
            if(r.success){ adminToast('QR Uploaded!'); setTimeout(()=>location.reload(),600); }
            else adminError(r.message);
        });
}
</script>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>
