<?php
define('ADMIN_PAGE', 'settings');
define('ADMIN_TITLE', 'Site Settings');
require_once __DIR__ . '/includes/admin-check.php';

$allSettings = fetchAll("SELECT * FROM `site_settings` ORDER BY `id` ASC");
$settingsMap = [];
foreach ($allSettings as $s) $settingsMap[$s['key']] = $s['value'];

require_once __DIR__ . '/includes/admin-header.php';
?>

<style>
.settings-tabs{display:flex;gap:8px;margin-bottom:20px;flex-wrap:wrap}
.stab{padding:8px 16px;border-radius:8px;border:1px solid rgba(255,255,255,.08);background:rgba(255,255,255,.03);color:#64748b;font-size:12px;font-weight:600;cursor:pointer;font-family:'Poppins',sans-serif;transition:.15s}
.stab.active{background:rgba(255,215,0,.08);border-color:rgba(255,215,0,.3);color:var(--admin-primary)}
.stab-panel{display:none}
.stab-panel.active{display:block}
.srow{display:flex;align-items:center;gap:12px;padding:10px 0;border-bottom:1px solid rgba(255,255,255,.04)}
.srow:last-child{border:none}
.srow-info{flex:1}
.srow-key{font-size:12px;font-weight:600;color:#e2e8f0}
.srow-desc{font-size:10px;color:#475569;margin-top:2px}
.logo-preview{width:60px;height:60px;object-fit:contain;border-radius:8px;border:1px solid rgba(255,255,255,.1);background:rgba(255,255,255,.05);padding:4px}
.favicon-preview{width:32px;height:32px;object-fit:contain;border-radius:4px}
</style>

<div class="settings-tabs">
    <button class="stab active" onclick="showTab('branding')">🎨 Branding</button>
    <button class="stab" onclick="showTab('general')">⚙️ General</button>
    <button class="stab" onclick="showTab('payments')">💳 Payments</button>
    <button class="stab" onclick="showTab('games')">🎮 Games</button>
    <button class="stab" onclick="showTab('referral')">👥 Referral</button>
    <button class="stab" onclick="showTab('fake')">🤖 Fake Stats</button>
    <button class="stab" onclick="showTab('support')">📞 Support</button>
    <button class="stab" onclick="showTab('advanced')">🔧 Advanced</button>
</div>

<!-- BRANDING TAB -->
<div class="stab-panel active" id="panel-branding">
<div class="admin-card">
    <div class="ac-header"><h3>🎨 Branding & Logo</h3></div>
    <div class="ac-body">
        <div class="srow">
            <div class="srow-info"><div class="srow-key">Site Logo</div><div class="srow-desc">Upload site logo (PNG/SVG recommended, transparent background)</div></div>
            <div style="display:flex;align-items:center;gap:10px">
                <?php if(!empty($settingsMap['site_logo'])): ?>
                <img src="<?php echo htmlspecialchars($settingsMap['site_logo']); ?>" class="logo-preview" id="logoPreview">
                <?php else: ?>
                <div class="logo-preview" id="logoPreview" style="display:flex;align-items:center;justify-content:center;color:#475569;font-size:20px">HC</div>
                <?php endif; ?>
                <div>
                    <input type="file" id="logoFile" accept="image/*" style="display:none" onchange="uploadBrandAsset('logo',this)">
                    <button class="admin-btn admin-btn-sm" style="background:rgba(255,255,255,.06);display:block;margin-bottom:4px" onclick="document.getElementById('logoFile').click()"><i class="fas fa-upload"></i> Upload Logo</button>
                    <input type="text" id="logo_url" class="admin-input" style="width:200px;height:30px;font-size:11px" placeholder="ya URL paste karo" value="<?php echo htmlspecialchars($settingsMap['site_logo']??''); ?>">
                </div>
            </div>
        </div>
        <div class="srow">
            <div class="srow-info"><div class="srow-key">Site Favicon</div><div class="srow-desc">Browser tab icon (32x32 or 64x64 PNG/ICO)</div></div>
            <div style="display:flex;align-items:center;gap:10px">
                <?php if(!empty($settingsMap['site_favicon'])): ?>
                <img src="<?php echo htmlspecialchars($settingsMap['site_favicon']); ?>" class="favicon-preview" id="faviconPreview">
                <?php else: ?>
                <div class="favicon-preview" id="faviconPreview" style="background:rgba(255,215,0,.1);border:1px solid rgba(255,215,0,.2);display:flex;align-items:center;justify-content:center;font-size:14px;border-radius:4px">HC</div>
                <?php endif; ?>
                <div>
                    <input type="file" id="faviconFile" accept="image/*" style="display:none" onchange="uploadBrandAsset('favicon',this)">
                    <button class="admin-btn admin-btn-sm" style="background:rgba(255,255,255,.06);display:block;margin-bottom:4px" onclick="document.getElementById('faviconFile').click()"><i class="fas fa-upload"></i> Upload Favicon</button>
                    <input type="text" id="favicon_url" class="admin-input" style="width:200px;height:30px;font-size:11px" placeholder="ya URL paste karo" value="<?php echo htmlspecialchars($settingsMap['site_favicon']??''); ?>">
                </div>
            </div>
        </div>
        <div class="srow">
            <div class="srow-info"><div class="srow-key">Site Name</div><div class="srow-desc">Website ka naam</div></div>
            <input type="text" name="settings[site_name]" value="<?php echo htmlspecialchars($settingsMap['site_name']??''); ?>" class="admin-input branding-field" style="width:200px">
        </div>
        <div class="srow">
            <div class="srow-info"><div class="srow-key">Site Tagline</div><div class="srow-desc">Tagline shown below name</div></div>
            <input type="text" name="settings[site_tagline]" value="<?php echo htmlspecialchars($settingsMap['site_tagline']??''); ?>" class="admin-input branding-field" style="width:200px">
        </div>
        <div style="padding:12px 0">
            <button class="admin-btn admin-btn-primary" onclick="saveBranding()"><i class="fas fa-save"></i> Save Branding</button>
        </div>
    </div>
</div>
</div>

<!-- GENERAL TAB -->
<div class="stab-panel" id="panel-general">
<div class="admin-card">
    <div class="ac-header"><h3>⚙️ General Settings</h3></div>
    <div class="ac-body" id="general-settings-body">
        <?php $generalKeys = ['site_url','currency_symbol','maintenance_mode','maintenance_message','withdrawal_processing_time'];
        foreach ($allSettings as $s): if (!in_array($s['key'], $generalKeys)) continue; ?>
        <div class="srow">
            <div class="srow-info"><div class="srow-key"><?php echo htmlspecialchars($s['key']); ?></div><?php if($s['description']): ?><div class="srow-desc"><?php echo htmlspecialchars($s['description']); ?></div><?php endif; ?></div>
            <?php if($s['value']==='0'||$s['value']==='1'): ?>
            <select name="settings[<?php echo $s['key']; ?>]" class="admin-select general-field" style="width:120px">
                <option value="0" <?php echo $s['value']==='0'?'selected':''; ?>>Off</option>
                <option value="1" <?php echo $s['value']==='1'?'selected':''; ?>>On</option>
            </select>
            <?php elseif(strlen($s['value'])>80): ?>
            <textarea name="settings[<?php echo $s['key']; ?>]" class="admin-input general-field" style="width:280px;height:50px"><?php echo htmlspecialchars($s['value']); ?></textarea>
            <?php else: ?>
            <input type="text" name="settings[<?php echo $s['key']; ?>]" value="<?php echo htmlspecialchars($s['value']); ?>" class="admin-input general-field" style="width:200px">
            <?php endif; ?>
        </div>
        <?php endforeach; ?>
        <div style="padding:12px 0"><button class="admin-btn admin-btn-primary" onclick="saveGroup('general-field','general')"><i class="fas fa-save"></i> Save General</button></div>
    </div>
</div>
</div>

<!-- PAYMENTS TAB -->
<div class="stab-panel" id="panel-payments">
<div class="admin-card">
    <div class="ac-header"><h3>💳 Payment Settings</h3></div>
    <div class="ac-body">
        <?php $paymentKeys = ['min_deposit','max_deposit','min_withdrawal','auto_approve_withdrawal','auto_approve_max','upi_collection_mode','withdrawal_wagering_multiplier'];
        foreach ($allSettings as $s): if (!in_array($s['key'], $paymentKeys)) continue; ?>
        <div class="srow">
            <div class="srow-info"><div class="srow-key"><?php echo htmlspecialchars($s['key']); ?></div><?php if($s['description']): ?><div class="srow-desc"><?php echo htmlspecialchars($s['description']); ?></div><?php endif; ?></div>
            <?php if($s['value']==='0'||$s['value']==='1'): ?>
            <select name="settings[<?php echo $s['key']; ?>]" class="admin-select payment-field" style="width:120px">
                <option value="0" <?php echo $s['value']==='0'?'selected':''; ?>>Off</option>
                <option value="1" <?php echo $s['value']==='1'?'selected':''; ?>>On</option>
            </select>
            <?php elseif($s['key']==='upi_collection_mode'): ?>
            <select name="settings[<?php echo $s['key']; ?>]" class="admin-select payment-field" style="width:120px">
                <option value="single" <?php echo $s['value']==='single'?'selected':''; ?>>Single</option>
                <option value="multi" <?php echo $s['value']==='multi'?'selected':''; ?>>Multi</option>
            </select>
            <?php else: ?>
            <input type="text" name="settings[<?php echo $s['key']; ?>]" value="<?php echo htmlspecialchars($s['value']); ?>" class="admin-input payment-field" style="width:160px">
            <?php endif; ?>
        </div>
        <?php endforeach; ?>
        <div style="padding:12px 0"><button class="admin-btn admin-btn-primary" onclick="saveGroup('payment-field','payments')"><i class="fas fa-save"></i> Save Payments</button></div>
    </div>
</div>
</div>

<!-- GAMES TAB -->
<div class="stab-panel" id="panel-games">
<div class="admin-card">
    <div class="ac-header"><h3>🎮 Game Settings</h3><a href="/admin/game-icons.php" class="admin-btn admin-btn-sm" style="background:rgba(255,215,0,.1);color:#FFD700"><i class="fas fa-palette"></i> Manage Icons</a></div>
    <div class="ac-body">
        <?php $gameKeys = ['min_bet_wingo','max_bet_wingo','min_bet_mine','max_bet_mine','spin_cost','free_spins_daily','first_deposit_show_bonus','first_deposit_real_bonus','bonus_wagering_multiplier','bonus_expiry_hours'];
        foreach ($allSettings as $s): if (!in_array($s['key'], $gameKeys)) continue; ?>
        <div class="srow">
            <div class="srow-info"><div class="srow-key"><?php echo htmlspecialchars($s['key']); ?></div><?php if($s['description']): ?><div class="srow-desc"><?php echo htmlspecialchars($s['description']); ?></div><?php endif; ?></div>
            <input type="text" name="settings[<?php echo $s['key']; ?>]" value="<?php echo htmlspecialchars($s['value']); ?>" class="admin-input game-field" style="width:160px">
        </div>
        <?php endforeach; ?>
        <div style="padding:12px 0"><button class="admin-btn admin-btn-primary" onclick="saveGroup('game-field','games')"><i class="fas fa-save"></i> Save Games</button></div>
    </div>
</div>
</div>

<!-- REFERRAL TAB -->
<div class="stab-panel" id="panel-referral">
<div class="admin-card"><div class="ac-header"><h3>👥 Referral Settings</h3></div><div class="ac-body">
    <?php $refKeys = ['referral_level1_commission','referral_level2_commission','referral_level3_commission','referral_registration_bonus'];
    foreach ($allSettings as $s): if (!in_array($s['key'], $refKeys)) continue; ?>
    <div class="srow">
        <div class="srow-info"><div class="srow-key"><?php echo htmlspecialchars($s['key']); ?></div><?php if($s['description']): ?><div class="srow-desc"><?php echo htmlspecialchars($s['description']); ?></div><?php endif; ?></div>
        <input type="text" name="settings[<?php echo $s['key']; ?>]" value="<?php echo htmlspecialchars($s['value']); ?>" class="admin-input referral-field" style="width:160px">
    </div>
    <?php endforeach; ?>
    <div style="padding:12px 0"><button class="admin-btn admin-btn-primary" onclick="saveGroup('referral-field','referral')"><i class="fas fa-save"></i> Save Referral</button></div>
</div></div>
</div>

<!-- FAKE STATS TAB -->
<div class="stab-panel" id="panel-fake">
<div class="admin-card"><div class="ac-header"><h3>🤖 Fake Statistics</h3></div><div class="ac-body">
    <?php $fakeKeys = ['fake_online_users_min','fake_online_users_max','fake_total_users','fake_today_winners','fake_total_payout'];
    foreach ($allSettings as $s): if (!in_array($s['key'], $fakeKeys)) continue; ?>
    <div class="srow">
        <div class="srow-info"><div class="srow-key"><?php echo htmlspecialchars($s['key']); ?></div><?php if($s['description']): ?><div class="srow-desc"><?php echo htmlspecialchars($s['description']); ?></div><?php endif; ?></div>
        <input type="text" name="settings[<?php echo $s['key']; ?>]" value="<?php echo htmlspecialchars($s['value']); ?>" class="admin-input fake-field" style="width:160px">
    </div>
    <?php endforeach; ?>
    <div style="padding:12px 0"><button class="admin-btn admin-btn-primary" onclick="saveGroup('fake-field','fake')"><i class="fas fa-save"></i> Save Fake Stats</button></div>
</div></div>
</div>

<!-- SUPPORT TAB -->
<div class="stab-panel" id="panel-support">
<div class="admin-card"><div class="ac-header"><h3>📞 Support Contacts</h3></div><div class="ac-body">
    <?php $suppKeys = ['support_email','admin_contact_whatsapp','admin_contact_telegram','admin_contact_telegram_channel'];
    foreach ($allSettings as $s): if (!in_array($s['key'], $suppKeys)) continue; ?>
    <div class="srow">
        <div class="srow-info"><div class="srow-key"><?php echo htmlspecialchars($s['key']); ?></div><?php if($s['description']): ?><div class="srow-desc"><?php echo htmlspecialchars($s['description']); ?></div><?php endif; ?></div>
        <input type="text" name="settings[<?php echo $s['key']; ?>]" value="<?php echo htmlspecialchars($s['value']); ?>" class="admin-input support-field" style="width:220px">
    </div>
    <?php endforeach; ?>
    <div style="padding:12px 0"><button class="admin-btn admin-btn-primary" onclick="saveGroup('support-field','support')"><i class="fas fa-save"></i> Save Support</button></div>
</div></div>
</div>

<!-- ADVANCED TAB -->
<div class="stab-panel" id="panel-advanced">
<div class="admin-card"><div class="ac-header"><h3>🔧 All Settings</h3></div><div class="ac-body">
    <form id="allSettingsForm">
    <?php foreach ($allSettings as $s): ?>
    <div class="srow">
        <div class="srow-info"><div class="srow-key"><?php echo htmlspecialchars($s['key']); ?></div><?php if($s['description']): ?><div class="srow-desc"><?php echo htmlspecialchars($s['description']); ?></div><?php endif; ?></div>
        <?php if(strlen($s['value'])>80): ?>
        <textarea name="settings[<?php echo $s['key']; ?>]" class="admin-input" style="width:260px;height:50px"><?php echo htmlspecialchars($s['value']); ?></textarea>
        <?php elseif($s['value']==='0'||$s['value']==='1'): ?>
        <select name="settings[<?php echo $s['key']; ?>]" class="admin-select" style="width:100px">
            <option value="0" <?php echo $s['value']==='0'?'selected':''; ?>>Off</option>
            <option value="1" <?php echo $s['value']==='1'?'selected':''; ?>>On</option>
        </select>
        <?php else: ?>
        <input type="text" name="settings[<?php echo $s['key']; ?>]" value="<?php echo htmlspecialchars($s['value']); ?>" class="admin-input" style="width:200px">
        <?php endif; ?>
    </div>
    <?php endforeach; ?>
    <div style="padding:14px 0"><button type="button" onclick="saveAllSettings()" class="admin-btn admin-btn-primary"><i class="fas fa-save"></i> Save All</button></div>
    </form>
</div></div>
</div>

<script>
function showTab(tab) {
    document.querySelectorAll('.stab').forEach(t=>t.classList.remove('active'));
    document.querySelectorAll('.stab-panel').forEach(p=>p.classList.remove('active'));
    event.target.classList.add('active');
    document.getElementById('panel-'+tab).classList.add('active');
}

function saveGroup(cls, label) {
    var data = {action:'update_settings'};
    document.querySelectorAll('.'+cls).forEach(function(el){
        var match = el.name && el.name.match(/settings\[(.+)\]/);
        if (match) data['settings['+match[1]+']'] = el.value;
    });
    adminAjax('/admin/api/settings.php', data, function(r){
        if(r.success) adminToast(label+' settings saved!');
        else adminError(r.message);
    });
}

function saveBranding() {
    var logoUrl = document.getElementById('logo_url').value.trim();
    var faviconUrl = document.getElementById('favicon_url').value.trim();
    var siteName = document.querySelector('[name="settings[site_name]"]').value;
    var siteTagline = document.querySelector('[name="settings[site_tagline]"]').value;
    adminAjax('/admin/api/settings.php', {
        action:'update_settings',
        'settings[site_logo]': logoUrl,
        'settings[site_favicon]': faviconUrl,
        'settings[site_name]': siteName,
        'settings[site_tagline]': siteTagline
    }, function(r){
        if(r.success) adminToast('Branding saved!');
        else adminError(r.message);
    });
}

function uploadBrandAsset(type, input) {
    var formData = new FormData();
    formData.append('action','upload_brand_asset');
    formData.append('csrf_token', document.querySelector('meta[name=csrf-token]').content);
    formData.append('asset_type', type);
    formData.append('file', input.files[0]);
    fetch('/admin/api/settings.php', {method:'POST', body:formData})
        .then(r=>r.json()).then(r=>{
            if(r.success){
                adminToast(type+' uploaded!');
                document.getElementById(type+'_url').value = r.url;
                if(type==='logo'){
                    document.getElementById('logoPreview').outerHTML = '<img src="'+r.url+'" class="logo-preview" id="logoPreview">';
                } else {
                    document.getElementById('faviconPreview').outerHTML = '<img src="'+r.url+'" class="favicon-preview" id="faviconPreview">';
                }
            } else adminError(r.message);
        });
}

function saveAllSettings() {
    var data = {action:'update_settings'};
    document.querySelectorAll('#allSettingsForm [name]').forEach(function(el){
        var m = el.name.match(/settings\[(.+)\]/);
        if(m) data['settings['+m[1]+']'] = el.value;
    });
    adminAjax('/admin/api/settings.php', data, function(r){
        if(r.success) adminToast('All settings saved!');
        else adminError(r.message);
    });
}
</script>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>
