<?php
define('ADMIN_PAGE', 'reports');
define('ADMIN_TITLE', 'Reports');
require_once __DIR__ . '/includes/admin-check.php';

$days = intval($_GET['days'] ?? 7);
$dailyStats = fetchAll("SELECT DATE(`created_at`) as date, COALESCE(SUM(CASE WHEN `type`='deposit' THEN `amount` END),0) as deposits, COALESCE(SUM(CASE WHEN `type`='withdrawal' THEN `amount` END),0) as withdrawals, COALESCE(SUM(CASE WHEN `type`='bet' THEN `amount` END),0) as bets, COALESCE(SUM(CASE WHEN `type`='win' THEN `amount` END),0) as wins FROM `transactions` WHERE `created_at` >= DATE_SUB(CURDATE(), INTERVAL ? DAY) GROUP BY DATE(`created_at`) ORDER BY date DESC", [$days]);

$dailyUsers = fetchAll("SELECT DATE(`created_at`) as date, COUNT(*) as cnt FROM `users` WHERE `created_at` >= DATE_SUB(CURDATE(), INTERVAL ? DAY) GROUP BY DATE(`created_at`) ORDER BY date DESC", [$days]);

require_once __DIR__ . '/includes/admin-header.php';
?>
<div class="admin-tabs">
    <a href="?days=7" class="admin-tab <?php echo $days===7?'active':''; ?>">7 Days</a>
    <a href="?days=14" class="admin-tab <?php echo $days===14?'active':''; ?>">14 Days</a>
    <a href="?days=30" class="admin-tab <?php echo $days===30?'active':''; ?>">30 Days</a>
</div>
<div class="admin-card">
    <div class="ac-header"><h3>📊 Financial Report — Last <?php echo $days; ?> Days</h3></div>
    <div class="admin-table-wrap">
        <table class="admin-table">
            <thead><tr><th>Date</th><th>Deposits</th><th>Withdrawals</th><th>Bets</th><th>Wins</th><th>Game Profit</th><th>Net</th></tr></thead>
            <tbody>
            <?php foreach ($dailyStats as $ds):
                $gp=(float)$ds['bets']-(float)$ds['wins'];
                $net=(float)$ds['deposits']-(float)$ds['withdrawals'];
            ?>
            <tr>
                <td><?php echo $ds['date']; ?></td>
                <td class="text-green">₹<?php echo number_format((float)$ds['deposits']); ?></td>
                <td class="text-red">₹<?php echo number_format((float)$ds['withdrawals']); ?></td>
                <td>₹<?php echo number_format((float)$ds['bets']); ?></td>
                <td>₹<?php echo number_format((float)$ds['wins']); ?></td>
                <td class="<?php echo $gp>=0?'text-green':'text-red'; ?>">₹<?php echo number_format($gp); ?></td>
                <td class="<?php echo $net>=0?'text-green':'text-red'; ?>" style="font-weight:700">₹<?php echo number_format($net); ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<div class="admin-card" style="margin-top:16px">
    <div class="ac-header"><h3>👥 Daily Registrations</h3></div>
    <div class="admin-table-wrap">
        <table class="admin-table">
            <thead><tr><th>Date</th><th>New Users</th></tr></thead>
            <tbody>
            <?php foreach ($dailyUsers as $du): ?>
            <tr><td><?php echo $du['date']; ?></td><td><?php echo $du['cnt']; ?></td></tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>