<?php
define('ADMIN_PAGE', 'notifications');
define('ADMIN_TITLE', 'Send Notifications');
require_once __DIR__ . '/includes/admin-check.php';
require_once __DIR__ . '/includes/admin-header.php';
?>
<div class="admin-card">
    <div class="ac-header"><h3>📢 Send Notification</h3></div>
    <div class="ac-body">
        <div style="display:flex;flex-direction:column;gap:12px;max-width:600px">
            <div>
                <label style="font-size:12px;color:#888;display:block;margin-bottom:4px">Target</label>
                <select id="notifTarget" class="admin-select" style="width:100%" onchange="document.getElementById('notifUserId').style.display=this.value==='single'?'':'none'">
                    <option value="all">All Active Users</option>
                    <option value="single">Single User</option>
                </select>
                <input type="number" id="notifUserId" class="admin-input" placeholder="User ID" style="display:none;margin-top:6px">
            </div>
            <div><label style="font-size:12px;color:#888;display:block;margin-bottom:4px">Title</label><input type="text" id="notifTitle" class="admin-input" placeholder="Notification title" style="width:100%"></div>
            <div><label style="font-size:12px;color:#888;display:block;margin-bottom:4px">Message</label><textarea id="notifMsg" class="admin-input" placeholder="Message body" style="width:100%;height:80px;resize:vertical"></textarea></div>
            <button onclick="sendNotif()" class="admin-btn admin-btn-primary"><i class="fas fa-paper-plane"></i> Send</button>
        </div>
    </div>
</div>
<script>
function sendNotif(){
    var target=document.getElementById('notifTarget').value;
    var data={action:'send_notification',target:target,title:document.getElementById('notifTitle').value,message:document.getElementById('notifMsg').value,type:'system'};
    if(target==='single')data.target_id=document.getElementById('notifUserId').value;
    if(!data.title||!data.message){adminError('Title and message required');return;}
    adminConfirm('Send?',target==='all'?'Send to ALL users?':'Send to user #'+data.target_id+'?','Send',function(){
        adminAjax('/admin/api/settings.php',data,function(r){if(r.success)adminToast(r.message);else adminError(r.message);});
    });
}
</script>
<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>