<?php
/**
 * Admin Login Page
 */
define('ADMIN_AREA', true);
require_once __DIR__ . '/../config.php';

if (!empty($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    redirect('/admin/dashboard.php');
}

$error = '';
$csrfToken = generateCSRFToken();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrf = $_POST['csrf_token'] ?? '';
    if (!verifyCSRFToken($csrf)) {
        $error = 'Invalid security token';
    } else {
        if (!rateLimit('admin_login', 5, 15)) {
            $error = 'Too many attempts. Wait 15 minutes.';
        } else {
            $username = sanitize(trim($_POST['username'] ?? ''));
            $password = $_POST['password'] ?? '';
            
            if (empty($username) || empty($password)) {
                $error = 'Enter username and password';
            } else {
                $admin = fetch("SELECT * FROM `admin_users` WHERE `username` = ? AND `is_active` = 1 LIMIT 1", [$username]);
                
                if (!$admin || !password_verify($password, $admin['password'])) {
                    $error = 'Invalid credentials';
                } else {
                    $_SESSION['admin_id'] = $admin['id'];
                    $_SESSION['admin_logged_in'] = true;
                    $_SESSION['admin_name'] = $admin['name'];
                    $_SESSION['admin_username'] = $admin['username'];
                    
                    try {
                        insert('admin_activity_log', [
                            'admin_id'   => $admin['id'],
                            'action'     => 'login',
                            'description'=> 'Admin login successful',
                            'ip_address' => getClientIP(),
                        ]);
                    } catch (Exception $e) {}
                    
                    redirect('/admin/dashboard.php');
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="robots" content="noindex,nofollow">
    <title>Admin Login — Hindustan Club</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <style>
    *{margin:0;padding:0;box-sizing:border-box}
    body{font-family:'Poppins',sans-serif;background:linear-gradient(135deg,#0d1117,#1a1a2e,#16213e);min-height:100vh;display:flex;align-items:center;justify-content:center;padding:20px}
    .login-card{width:100%;max-width:380px;background:#1f2940;border:1px solid rgba(255,255,255,.06);border-radius:16px;padding:30px 24px;box-shadow:0 10px 40px rgba(0,0,0,.4)}
    .logo{text-align:center;margin-bottom:24px}
    .logo-icon{width:56px;height:56px;border-radius:14px;background:linear-gradient(135deg,#FFD700,#FFA000);display:flex;align-items:center;justify-content:center;font-size:20px;font-weight:800;color:#1a1a2e;margin:0 auto 10px}
    .logo h1{font-size:18px;color:#fff;font-weight:700}
    .logo p{font-size:11px;color:#888}
    .alert{padding:10px 14px;border-radius:8px;font-size:12px;margin-bottom:14px;background:rgba(255,68,68,.08);border:1px solid rgba(255,68,68,.15);color:#FF6B6B;display:flex;align-items:center;gap:6px}
    .field{margin-bottom:14px}
    .field label{display:block;font-size:11px;color:#888;margin-bottom:4px;font-weight:500}
    .field input{width:100%;height:44px;background:#2a3352;border:1.5px solid #3d4f7c;border-radius:8px;color:#fff;font-size:14px;padding:0 12px;outline:none;font-family:'Poppins',sans-serif;transition:.2s}
    .field input:focus{border-color:#FFD700;box-shadow:0 0 0 3px rgba(255,215,0,.08)}
    .submit-btn{width:100%;height:46px;border:none;border-radius:8px;background:linear-gradient(135deg,#FFD700,#FFA000);color:#1a1a2e;font-size:14px;font-weight:700;cursor:pointer;font-family:'Poppins',sans-serif;margin-top:6px;transition:.2s}
    .submit-btn:hover{filter:brightness(1.08)}
    </style>
</head>
<body>
<div class="login-card">
    <div class="logo">
        <div class="logo-icon">HC</div>
        <h1>Admin Panel</h1>
        <p>Hindustan Club — Management</p>
    </div>
    <?php if ($error): ?>
    <div class="alert"><i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <form method="POST">
        <input type="hidden" name="csrf_token" value="<?php echo $csrfToken; ?>">
        <div class="field">
            <label>Username</label>
            <input type="text" name="username" required autocomplete="username" value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>">
        </div>
        <div class="field">
            <label>Password</label>
            <input type="password" name="password" required autocomplete="current-password">
        </div>
        <button type="submit" class="submit-btn"><i class="fas fa-lock"></i> Login</button>
    </form>
</div>
</body>
</html>