<?php
$_adminPage = defined('ADMIN_PAGE') ? ADMIN_PAGE : 'dashboard';
$_adminTitle = defined('ADMIN_TITLE') ? ADMIN_TITLE : 'Admin Panel';

$pendingDeposits = (int)(fetch("SELECT COUNT(*) as c FROM `deposits` WHERE `status`='pending'")['c'] ?? 0);
$pendingWithdrawals = (int)(fetch("SELECT COUNT(*) as c FROM `withdrawals` WHERE `status`='pending'")['c'] ?? 0);

$siteLogo = getSetting('site_logo', '');
$siteFavicon = getSetting('site_favicon', '');
$siteName = getSetting('site_name', 'Hindustan Club');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="robots" content="noindex,nofollow">
    <meta name="csrf-token" content="<?php echo $adminCSRF; ?>">
    <title><?php echo htmlspecialchars($_adminTitle); ?> — <?php echo htmlspecialchars($siteName); ?> Admin</title>
    <?php if (!empty($siteFavicon)): ?>
    <link rel="icon" href="<?php echo htmlspecialchars($siteFavicon); ?>" type="image/x-icon">
    <?php endif; ?>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <link href="/admin/assets/css/admin.css" rel="stylesheet">
</head>
<body class="admin-body">

<aside class="admin-sidebar" id="adminSidebar">
    <div class="as-header">
        <?php if (!empty($siteLogo)): ?>
        <img src="<?php echo htmlspecialchars($siteLogo); ?>" style="width:36px;height:36px;object-fit:contain;border-radius:8px" alt="logo">
        <?php else: ?>
        <div class="as-logo">HC</div>
        <?php endif; ?>
        <div class="as-title">
            <span class="as-name"><?php echo htmlspecialchars($siteName); ?></span>
            <span class="as-sub">Admin Panel</span>
        </div>
        <button class="as-close" onclick="toggleSidebar()">✕</button>
    </div>
    <nav class="as-nav">
        <a href="/admin/dashboard.php" class="as-item <?php echo $_adminPage==='dashboard'?'active':''; ?>"><i class="fas fa-home"></i><span>Dashboard</span></a>
        <a href="/admin/users.php" class="as-item <?php echo $_adminPage==='users'?'active':''; ?>"><i class="fas fa-users"></i><span>Users</span></a>
        <a href="/admin/deposits.php" class="as-item <?php echo $_adminPage==='deposits'?'active':''; ?>"><i class="fas fa-arrow-down"></i><span>Deposits</span><?php if($pendingDeposits>0):?><span class="as-badge"><?php echo $pendingDeposits; ?></span><?php endif; ?></a>
        <a href="/admin/withdrawals.php" class="as-item <?php echo $_adminPage==='withdrawals'?'active':''; ?>"><i class="fas fa-arrow-up"></i><span>Withdrawals</span><?php if($pendingWithdrawals>0):?><span class="as-badge"><?php echo $pendingWithdrawals; ?></span><?php endif; ?></a>
        <div class="as-divider"></div>
        <a href="/admin/wingo-control.php" class="as-item <?php echo $_adminPage==='wingo'?'active':''; ?>"><i class="fas fa-bullseye"></i><span>Wingo Control</span></a>
        <a href="/admin/algorithm.php" class="as-item <?php echo $_adminPage==='algorithm'?'active':''; ?>"><i class="fas fa-brain"></i><span>Algorithm</span></a>
        <a href="/admin/spin-control.php" class="as-item <?php echo $_adminPage==='spin'?'active':''; ?>"><i class="fas fa-dharmachakra"></i><span>Spin Control</span></a>
        <div class="as-divider"></div>
        <a href="/admin/upi-settings.php" class="as-item <?php echo $_adminPage==='upi'?'active':''; ?>"><i class="fas fa-qrcode"></i><span>UPI Settings</span></a>
        <a href="/admin/game-icons.php" class="as-item <?php echo $_adminPage==='gameicons'?'active':''; ?>"><i class="fas fa-palette"></i><span>Game Icons</span></a>
        <a href="/admin/gift-codes.php" class="as-item <?php echo $_adminPage==='giftcodes'?'active':''; ?>"><i class="fas fa-ticket"></i><span>Gift Codes</span></a>
        <a href="/admin/notifications-manage.php" class="as-item <?php echo $_adminPage==='notifications'?'active':''; ?>"><i class="fas fa-bell"></i><span>Notifications</span></a>
        <a href="/admin/site-settings.php" class="as-item <?php echo $_adminPage==='settings'?'active':''; ?>"><i class="fas fa-cog"></i><span>Site Settings</span></a>
        <div class="as-divider"></div>
        <a href="/admin/reports.php" class="as-item <?php echo $_adminPage==='reports'?'active':''; ?>"><i class="fas fa-chart-bar"></i><span>Reports</span></a>
        <a href="/admin/activity-log.php" class="as-item <?php echo $_adminPage==='activitylog'?'active':''; ?>"><i class="fas fa-history"></i><span>Activity Log</span></a>
        <a href="/admin/logout.php" class="as-item as-logout"><i class="fas fa-sign-out-alt"></i><span>Logout</span></a>
    </nav>
</aside>

<main class="admin-main" id="adminMain">
    <header class="admin-topbar">
        <div class="at-left">
            <button class="at-menu-btn" onclick="toggleSidebar()"><i class="fas fa-bars"></i></button>
            <h1 class="at-title"><?php echo htmlspecialchars($_adminTitle); ?></h1>
        </div>
        <div class="at-right">
            <?php if ($pendingDeposits > 0 || $pendingWithdrawals > 0): ?>
            <div class="at-alerts">
                <?php if ($pendingDeposits > 0): ?><a href="/admin/deposits.php" class="at-alert-badge">📥 <?php echo $pendingDeposits; ?></a><?php endif; ?>
                <?php if ($pendingWithdrawals > 0): ?><a href="/admin/withdrawals.php" class="at-alert-badge at-alert-warn">📤 <?php echo $pendingWithdrawals; ?></a><?php endif; ?>
            </div>
            <?php endif; ?>
            <div class="at-user">
                <span class="at-user-name"><?php echo htmlspecialchars($adminName); ?></span>
            </div>
        </div>
    </header>
    <div class="admin-content">
