<?php
/**
 * Admin Authentication Middleware
 */
define('ADMIN_AREA', true);
require_once __DIR__ . '/../../config.php';

if (empty($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true || empty($_SESSION['admin_id'])) {
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
        jsonResponse(false, 'Admin session expired', ['redirect' => '/admin/']);
    }
    header('Location: /admin/');
    exit;
}

$adminUser = fetch("SELECT * FROM `admin_users` WHERE `id` = ? AND `is_active` = 1 LIMIT 1", [$_SESSION['admin_id']]);
if (!$adminUser) {
    unset($_SESSION['admin_id'], $_SESSION['admin_logged_in'], $_SESSION['admin_name']);
    header('Location: /admin/');
    exit;
}

$adminId = (int)$adminUser['id'];
$adminName = $adminUser['name'];
$adminUsername = $adminUser['username'];
$adminCSRF = generateCSRFToken();

function logAdmin(string $action, string $description = ''): void
{
    global $adminId;
    try {
        insert('admin_activity_log', [
            'admin_id'    => $adminId,
            'action'      => $action,
            'description' => substr($description, 0, 500),
            'ip_address'  => getClientIP(),
        ]);
    } catch (Exception $e) {
        error_log('Admin log error: ' . $e->getMessage());
    }
}