<?php
define('ADMIN_PAGE', 'giftcodes');
define('ADMIN_TITLE', 'Gift Codes');
require_once __DIR__ . '/includes/admin-check.php';
$codes = fetchAll("SELECT * FROM `gift_codes` ORDER BY `id` DESC LIMIT 50");
require_once __DIR__ . '/includes/admin-header.php';
?>
<div class="admin-card">
    <div class="ac-header"><h3>🎟️ Gift Codes</h3><button onclick="createCode()" class="admin-btn admin-btn-primary admin-btn-sm"><i class="fas fa-plus"></i> Create</button></div>
    <div class="admin-table-wrap">
        <table class="admin-table">
            <thead><tr><th>Code</th><th>Amount</th><th>Used</th><th>Max</th><th>Min Dep</th><th>Wagering</th><th>Expires</th><th>Active</th><th>Actions</th></tr></thead>
            <tbody>
            <?php foreach ($codes as $c): ?>
            <tr>
                <td style="font-weight:700;color:#FFD700"><?php echo htmlspecialchars($c['code']); ?></td>
                <td>₹<?php echo number_format((float)$c['bonus_amount']); ?></td>
                <td><?php echo $c['used_count']; ?></td>
                <td><?php echo $c['max_uses'] ?: '∞'; ?></td>
                <td>₹<?php echo number_format((float)$c['min_deposit']); ?></td>
                <td><?php echo $c['wagering_multiplier']; ?>x</td>
                <td style="font-size:11px"><?php echo $c['expires_at'] ? formatDate($c['expires_at']) : 'Never'; ?></td>
                <td><span class="admin-badge <?php echo $c['is_active']?'badge-success':'badge-danger'; ?>"><?php echo $c['is_active']?'On':'Off'; ?></span></td>
                <td><button onclick="toggleGC(<?php echo $c['id']; ?>,<?php echo $c['is_active']?0:1; ?>)" class="admin-btn admin-btn-sm"><?php echo $c['is_active']?'Off':'On'; ?></button></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<script>
function createCode(){Swal.fire({title:'Create Gift Code',html:'<input id="gc-code" class="swal2-input" placeholder="CODE" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c;text-transform:uppercase"><input id="gc-amount" type="number" class="swal2-input" placeholder="Bonus Amount" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c"><input id="gc-max" type="number" class="swal2-input" placeholder="Max Uses (0=unlimited)" value="0" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c"><input id="gc-mindep" type="number" class="swal2-input" placeholder="Min Deposit (0=none)" value="0" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c"><input id="gc-wager" type="number" class="swal2-input" placeholder="Wagering (5=5x)" value="5" style="background:#1a1a2e;color:#fff;border:1px solid #3d4f7c">',showCancelButton:true,background:'#1f2940',color:'#fff',confirmButtonColor:'#FFD700',confirmButtonText:'Create'}).then(function(r){if(r.isConfirmed){adminAjax('/admin/api/settings.php',{action:'create_gift_code',code:document.getElementById('gc-code').value,amount:document.getElementById('gc-amount').value,max_uses:document.getElementById('gc-max').value,min_deposit:document.getElementById('gc-mindep').value,wagering:document.getElementById('gc-wager').value,max_per_user:1,expires_at:''},function(res){if(res.success){adminToast('Code created!');location.reload();}else adminError(res.message);});}});}
function toggleGC(id,active){adminAjax('/admin/api/settings.php',{action:'toggle_gift_code',gift_code_id:id,is_active:active},function(r){if(r.success)location.reload();else adminError(r.message);});}
</script>
<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>