<?php
define('ADMIN_PAGE', 'gameicons');
define('ADMIN_TITLE', 'Game Icons Manager');
require_once __DIR__ . '/includes/admin-check.php';

$games = fetchAll("SELECT * FROM `games_config` ORDER BY `sort_order` ASC");

require_once __DIR__ . '/includes/admin-header.php';
?>

<style>
.icon-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(280px,1fr));gap:16px}
.icon-card{background:rgba(255,255,255,.03);border:1px solid rgba(255,255,255,.06);border-radius:14px;padding:20px;text-align:center;transition:.2s}
.icon-card:hover{border-color:rgba(255,215,0,.2);background:rgba(255,215,0,.02)}
.game-icon-preview{width:72px;height:72px;border-radius:18px;display:flex;align-items:center;justify-content:center;margin:0 auto 12px;font-size:28px;transition:.3s}
.game-icon-preview.fa-icon i{font-size:26px}
.game-icon-preview.emoji-icon{font-size:34px}
.game-name{font-size:14px;font-weight:700;color:#fff;margin-bottom:4px}
.game-key{font-size:10px;color:#475569;margin-bottom:14px}
.icon-tabs{display:flex;gap:6px;margin-bottom:12px;background:rgba(0,0,0,.2);border-radius:8px;padding:3px}
.icon-tab{flex:1;padding:6px;border-radius:6px;border:none;background:none;color:#64748b;font-size:11px;font-weight:600;cursor:pointer;font-family:'Poppins',sans-serif;transition:.15s}
.icon-tab.active{background:var(--admin-primary);color:#1a1a2e}
.icon-tab-content{display:none}
.icon-tab-content.active{display:block}
.emoji-picker{display:grid;grid-template-columns:repeat(6,1fr);gap:4px;max-height:150px;overflow-y:auto;padding:4px}
.emoji-opt{background:rgba(255,255,255,.04);border:1px solid rgba(255,255,255,.06);border-radius:6px;padding:6px;font-size:18px;cursor:pointer;text-align:center;transition:.15s}
.emoji-opt:hover{background:rgba(255,215,0,.1);border-color:rgba(255,215,0,.3)}
.emoji-opt.selected{background:rgba(255,215,0,.15);border-color:var(--admin-primary)}
.fa-search-row{display:flex;gap:6px;margin-bottom:8px}
.fa-results{display:grid;grid-template-columns:repeat(5,1fr);gap:4px;max-height:150px;overflow-y:auto}
.fa-opt{background:rgba(255,255,255,.04);border:1px solid rgba(255,255,255,.06);border-radius:6px;padding:8px;cursor:pointer;text-align:center;color:#94a3b8;transition:.15s;font-size:14px}
.fa-opt:hover{color:#FFD700;background:rgba(255,215,0,.08);border-color:rgba(255,215,0,.3)}
.fa-opt.selected{color:#FFD700;background:rgba(255,215,0,.12);border-color:var(--admin-primary)}
.color-row{display:flex;gap:6px;flex-wrap:wrap;margin-top:8px}
.color-swatch{width:28px;height:28px;border-radius:6px;cursor:pointer;border:2px solid transparent;transition:.15s}
.color-swatch.selected{border-color:#fff;transform:scale(1.15)}
</style>

<p style="font-size:12px;color:#64748b;margin-bottom:16px">Games ke icons customize karo — FontAwesome class, Emoji, ya custom color use kar sakte ho.</p>

<div class="icon-grid">
<?php foreach($games as $g): 
    $iconType = $g['icon_type'] ?? 'fa';
    $iconBg = $g['icon_bg_color'] ?? '#FFD700';
    $icon = $g['icon'] ?? 'fas fa-gamepad';
?>
<div class="icon-card" id="icard-<?php echo $g['id']; ?>">
    <div class="game-icon-preview <?php echo $iconType; ?>-icon" id="preview-<?php echo $g['id']; ?>" style="background:<?php echo $iconBg; ?>20;color:<?php echo $iconBg; ?>">
        <?php if($iconType === 'fa'): ?><i class="<?php echo htmlspecialchars($icon); ?>"></i>
        <?php elseif($iconType === 'emoji'): ?><?php echo htmlspecialchars($icon); ?>
        <?php else: ?><img src="<?php echo htmlspecialchars($icon); ?>" style="width:40px;height:40px;object-fit:cover;border-radius:8px">
        <?php endif; ?>
    </div>
    <div class="game-name"><?php echo htmlspecialchars($g['game_name']); ?></div>
    <div class="game-key"><?php echo htmlspecialchars($g['game_key']); ?></div>
    
    <div class="icon-tabs">
        <button class="icon-tab <?php echo $iconType==='fa'?'active':''; ?>" onclick="switchTab(<?php echo $g['id']; ?>,'fa')">🔤 FA Icon</button>
        <button class="icon-tab <?php echo $iconType==='emoji'?'active':''; ?>" onclick="switchTab(<?php echo $g['id']; ?>,'emoji')">😀 Emoji</button>
    </div>
    
    <!-- FA Tab -->
    <div class="icon-tab-content <?php echo $iconType==='fa'?'active':''; ?>" id="tab-fa-<?php echo $g['id']; ?>">
        <div class="fa-search-row">
            <input type="text" class="admin-input" style="flex:1;height:32px;font-size:11px" placeholder="Search icon (e.g. star, bolt...)" onkeyup="searchFa(this,<?php echo $g['id']; ?>)">
        </div>
        <div class="fa-results" id="fa-results-<?php echo $g['id']; ?>">
            <?php 
            $faIcons = ['fas fa-gamepad','fas fa-bullseye','fas fa-bomb','fas fa-dharmachakra','fas fa-trophy','fas fa-star','fas fa-bolt','fas fa-fire','fas fa-gem','fas fa-crown','fas fa-dice','fas fa-coins','fas fa-shield','fas fa-sword','fas fa-magic','fas fa-rocket','fas fa-basketball-ball','fas fa-football-ball','fas fa-chess','fas fa-puzzle-piece'];
            foreach($faIcons as $fi): ?>
            <div class="fa-opt <?php echo $icon===$fi&&$iconType==='fa'?'selected':''; ?>" onclick="selectFa(<?php echo $g['id']; ?>,'<?php echo $fi; ?>')" title="<?php echo $fi; ?>"><i class="<?php echo $fi; ?>"></i></div>
            <?php endforeach; ?>
        </div>
        <input type="hidden" id="fa-val-<?php echo $g['id']; ?>" value="<?php echo $iconType==='fa'?htmlspecialchars($icon):'fas fa-gamepad'; ?>">
    </div>
    
    <!-- Emoji Tab -->
    <div class="icon-tab-content <?php echo $iconType==='emoji'?'active':''; ?>" id="tab-emoji-<?php echo $g['id']; ?>">
        <div class="emoji-picker" id="emoji-picker-<?php echo $g['id']; ?>">
            <?php $emojis = ['🎮','🎯','💣','🎡','🏆','⭐','⚡','🔥','💎','👑','🎲','🪙','🛡️','⚔️','🪄','🚀','🎰','🃏','🀄','🎳','🎪','🏅','🎁','🌟','💫','🎊','🤑','💰','🦁','🐉'];
            foreach($emojis as $em): ?>
            <div class="emoji-opt <?php echo $icon===$em&&$iconType==='emoji'?'selected':''; ?>" onclick="selectEmoji(<?php echo $g['id']; ?>,'<?php echo $em; ?>')"><?php echo $em; ?></div>
            <?php endforeach; ?>
        </div>
        <input type="hidden" id="emoji-val-<?php echo $g['id']; ?>" value="<?php echo $iconType==='emoji'?htmlspecialchars($icon):'🎮'; ?>">
    </div>
    
    <!-- Color -->
    <div style="margin-top:10px;text-align:left">
        <div style="font-size:10px;color:#64748b;margin-bottom:6px;font-weight:600">Icon Background Color</div>
        <div class="color-row">
            <?php $colors = ['#e74c3c','#e67e22','#f39c12','#FFD700','#2ecc71','#1abc9c','#3498db','#9b59b6','#e91e63','#ff5722','#607d8b','#ffffff'];
            foreach($colors as $c): ?>
            <div class="color-swatch <?php echo $iconBg===$c?'selected':''; ?>" style="background:<?php echo $c; ?>" onclick="selectColor(<?php echo $g['id']; ?>,'<?php echo $c; ?>')" title="<?php echo $c; ?>"></div>
            <?php endforeach; ?>
            <input type="color" id="custom-color-<?php echo $g['id']; ?>" value="<?php echo $iconBg; ?>" style="width:28px;height:28px;border-radius:6px;border:none;cursor:pointer;padding:0" onchange="selectColor(<?php echo $g['id']; ?>,this.value)">
        </div>
        <input type="hidden" id="color-val-<?php echo $g['id']; ?>" value="<?php echo $iconBg; ?>">
    </div>
    
    <input type="hidden" id="type-val-<?php echo $g['id']; ?>" value="<?php echo $iconType; ?>">
    
    <button class="admin-btn admin-btn-primary" style="width:100%;margin-top:14px" onclick="saveIcon(<?php echo $g['id']; ?>)">
        <i class="fas fa-save"></i> Save Icon
    </button>
</div>
<?php endforeach; ?>
</div>

<script>
function switchTab(id, tab) {
    document.querySelectorAll('#icard-'+id+' .icon-tab').forEach(t=>t.classList.remove('active'));
    document.querySelectorAll('#icard-'+id+' .icon-tab-content').forEach(t=>t.classList.remove('active'));
    event.target.classList.add('active');
    document.getElementById('tab-'+tab+'-'+id).classList.add('active');
    document.getElementById('type-val-'+id).value = tab;
    updatePreview(id);
}

function selectFa(id, cls) {
    document.querySelectorAll('#fa-results-'+id+' .fa-opt').forEach(o=>o.classList.remove('selected'));
    event.target.closest('.fa-opt').classList.add('selected');
    document.getElementById('fa-val-'+id).value = cls;
    document.getElementById('type-val-'+id).value = 'fa';
    updatePreview(id);
}

function selectEmoji(id, em) {
    document.querySelectorAll('#emoji-picker-'+id+' .emoji-opt').forEach(o=>o.classList.remove('selected'));
    event.target.classList.add('selected');
    document.getElementById('emoji-val-'+id).value = em;
    document.getElementById('type-val-'+id).value = 'emoji';
    updatePreview(id);
}

function selectColor(id, color) {
    document.querySelectorAll('#icard-'+id+' .color-swatch').forEach(s=>s.classList.remove('selected'));
    if(event.target.classList.contains('color-swatch')) event.target.classList.add('selected');
    document.getElementById('color-val-'+id).value = color;
    updatePreview(id);
}

function updatePreview(id) {
    var type = document.getElementById('type-val-'+id).value;
    var color = document.getElementById('color-val-'+id).value;
    var preview = document.getElementById('preview-'+id);
    preview.style.background = color + '20';
    preview.style.color = color;
    if (type === 'fa') {
        var cls = document.getElementById('fa-val-'+id).value;
        preview.innerHTML = '<i class="'+cls+'"></i>';
    } else if (type === 'emoji') {
        var em = document.getElementById('emoji-val-'+id).value;
        preview.innerHTML = em;
    }
}

function searchFa(input, id) {
    var q = input.value.toLowerCase();
    var allFa = ['fas fa-gamepad','fas fa-bullseye','fas fa-bomb','fas fa-dharmachakra','fas fa-trophy','fas fa-star','fas fa-bolt','fas fa-fire','fas fa-gem','fas fa-crown','fas fa-dice','fas fa-coins','fas fa-shield','fas fa-magic','fas fa-rocket','fas fa-basketball-ball','fas fa-football-ball','fas fa-chess','fas fa-puzzle-piece','fas fa-spade','fas fa-heart','fas fa-diamond','fas fa-club','fas fa-ticket','fas fa-money-bill','fas fa-gift','fas fa-percent','fas fa-chart-bar','fas fa-chart-line','fas fa-arrow-up','fas fa-arrow-down','fas fa-play','fas fa-circle','fas fa-square','fas fa-bell','fas fa-flag','fas fa-map','fas fa-compass','fas fa-crosshairs'];
    var filtered = q ? allFa.filter(f=>f.includes(q)) : allFa;
    var container = document.getElementById('fa-results-'+id);
    container.innerHTML = filtered.slice(0,20).map(fi=>'<div class="fa-opt" onclick="selectFa('+id+',\''+fi+'\')" title="'+fi+'"><i class="'+fi+'"></i></div>').join('');
}

function saveIcon(id) {
    var type = document.getElementById('type-val-'+id).value;
    var icon = type === 'fa' ? document.getElementById('fa-val-'+id).value : document.getElementById('emoji-val-'+id).value;
    var color = document.getElementById('color-val-'+id).value;
    adminAjax('/admin/api/games.php', {action:'update_game_icon', game_id:id, icon:icon, icon_type:type, icon_bg_color:color}, function(r){
        if(r.success) adminToast('Icon saved!');
        else adminError(r.message);
    });
}
</script>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>
