<?php
define('ADMIN_PAGE', 'deposits');
define('ADMIN_TITLE', 'Manage Deposits');
require_once __DIR__ . '/includes/admin-check.php';

$status = sanitize($_GET['status'] ?? 'pending');
$page = max(1, intval($_GET['page'] ?? 1));
$perPage = 20;
$offset = ($page - 1) * $perPage;

$where = "1=1";
$params = [];
if (in_array($status, ['pending','approved','rejected'])) {
    $where .= " AND d.`status` = ?";
    $params[] = $status;
}

$total = (int)(fetch("SELECT COUNT(*) as c FROM `deposits` d WHERE $where", $params)['c'] ?? 0);
$totalPages = max(1, ceil($total / $perPage));
$deposits = fetchAll("SELECT d.*, u.`name`, u.`phone` FROM `deposits` d JOIN `users` u ON d.`user_id`=u.`id` WHERE $where ORDER BY d.`created_at` DESC LIMIT $perPage OFFSET $offset", $params);

require_once __DIR__ . '/includes/admin-header.php';
?>

<div class="admin-tabs">
    <a href="?status=pending" class="admin-tab <?php echo $status==='pending'?'active':''; ?>">Pending <span class="admin-tab-badge"><?php echo (int)(fetch("SELECT COUNT(*) as c FROM `deposits` WHERE `status`='pending'")['c']??0); ?></span></a>
    <a href="?status=approved" class="admin-tab <?php echo $status==='approved'?'active':''; ?>">Approved</a>
    <a href="?status=rejected" class="admin-tab <?php echo $status==='rejected'?'active':''; ?>">Rejected</a>
    <a href="?status=" class="admin-tab <?php echo empty($status)?'active':''; ?>">All</a>
</div>

<div class="admin-card">
    <div class="admin-table-wrap">
        <table class="admin-table">
            <thead>
                <tr>
                    <th>ID</th><th>User</th><th>Amount</th><th>UTR</th><th>UPI</th><th>Screenshot</th><th>Status</th><th>Time</th><th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($deposits as $d): ?>
                <tr>
                    <td>#<?php echo $d['id']; ?></td>
                    <td><a href="/admin/user-detail.php?id=<?php echo $d['user_id']; ?>" style="color:#FFD700"><?php echo htmlspecialchars($d['name']); ?></a><br><span style="font-size:10px;color:#888"><?php echo $d['phone']; ?></span></td>
                    <td class="text-green" style="font-weight:700">₹<?php echo number_format((float)$d['amount']); ?></td>
                    <td style="font-family:monospace;font-size:11px"><?php echo htmlspecialchars($d['utr_number']); ?></td>
                    <td style="font-size:11px"><?php echo htmlspecialchars($d['upi_id_used'] ?? '—'); ?></td>
                    <td>
                        <?php if ($d['screenshot']): ?>
                        <a href="<?php echo UPLOADS_URL . '/' . $d['screenshot']; ?>" target="_blank" class="admin-btn admin-btn-sm"><i class="fas fa-image"></i></a>
                        <?php else: ?>—<?php endif; ?>
                    </td>
                    <td><span class="admin-badge <?php echo $d['status']==='pending'?'badge-warning':($d['status']==='approved'?'badge-success':'badge-danger'); ?>"><?php echo ucfirst($d['status']); ?></span></td>
                    <td style="font-size:11px"><?php echo timeAgo($d['created_at']); ?></td>
                    <td>
                        <?php if ($d['status'] === 'pending'): ?>
                        <button onclick="approveDeposit(<?php echo $d['id']; ?>,<?php echo (float)$d['amount']; ?>)" class="admin-btn admin-btn-sm admin-btn-success"><i class="fas fa-check"></i></button>
                        <button onclick="rejectDeposit(<?php echo $d['id']; ?>)" class="admin-btn admin-btn-sm admin-btn-danger"><i class="fas fa-times"></i></button>
                        <?php else: ?>—<?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php if ($totalPages > 1): ?>
    <div class="admin-pagination">
        <?php for ($p = max(1,$page-3); $p <= min($totalPages,$page+3); $p++): ?>
        <a href="?status=<?php echo $status; ?>&page=<?php echo $p; ?>" class="admin-page-btn <?php echo $p===$page?'active':''; ?>"><?php echo $p; ?></a>
        <?php endfor; ?>
    </div>
    <?php endif; ?>
</div>

<script>
function approveDeposit(id, amount) {
    adminConfirm('Approve Deposit?', 'Approve ₹' + amount.toLocaleString() + ' deposit?', 'Approve', function() {
        adminAjax('/admin/api/finance.php', {action:'approve_deposit', deposit_id:id}, function(r) {
            if(r.success) { adminToast('Deposit approved!'); location.reload(); }
            else adminError(r.message);
        });
    });
}
function rejectDeposit(id) {
    Swal.fire({title:'Reject Deposit',input:'text',inputPlaceholder:'Rejection reason',showCancelButton:true,background:'#1f2940',color:'#fff',confirmButtonColor:'#ef4444',confirmButtonText:'Reject'}).then(function(r) {
        if(r.isConfirmed) {
            adminAjax('/admin/api/finance.php', {action:'reject_deposit', deposit_id:id, reason:r.value||'Rejected by admin'}, function(res) {
                if(res.success) { adminToast('Deposit rejected'); location.reload(); }
                else adminError(res.message);
            });
        }
    });
}
</script>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>