<?php
define('ADMIN_PAGE', 'dashboard');
define('ADMIN_TITLE', 'Dashboard');
require_once __DIR__ . '/includes/admin-check.php';

// Stats
$totalUsers = (int)(fetch("SELECT COUNT(*) as c FROM `users`")['c'] ?? 0);
$todayUsers = (int)(fetch("SELECT COUNT(*) as c FROM `users` WHERE DATE(`created_at`)=CURDATE()")['c'] ?? 0);
$activeUsers = (int)(fetch("SELECT COUNT(*) as c FROM `users` WHERE `last_login` > DATE_SUB(NOW(), INTERVAL 24 HOUR)")['c'] ?? 0);
$bannedUsers = (int)(fetch("SELECT COUNT(*) as c FROM `users` WHERE `status`='banned'")['c'] ?? 0);

$totalDeposited = (float)(fetch("SELECT COALESCE(SUM(`amount`),0) as t FROM `deposits` WHERE `status`='approved'")['t'] ?? 0);
$todayDeposited = (float)(fetch("SELECT COALESCE(SUM(`amount`),0) as t FROM `deposits` WHERE `status`='approved' AND DATE(`created_at`)=CURDATE()")['t'] ?? 0);
$totalWithdrawn = (float)(fetch("SELECT COALESCE(SUM(`amount`),0) as t FROM `withdrawals` WHERE `status`='completed'")['t'] ?? 0);
$todayWithdrawnTotal = (float)(fetch("SELECT COALESCE(SUM(`amount`),0) as t FROM `withdrawals` WHERE `status`='completed' AND DATE(`created_at`)=CURDATE()")['t'] ?? 0);

$pendingDep = (int)(fetch("SELECT COUNT(*) as c FROM `deposits` WHERE `status`='pending'")['c'] ?? 0);
$pendingWd = (int)(fetch("SELECT COUNT(*) as c FROM `withdrawals` WHERE `status`='pending'")['c'] ?? 0);

$totalBets = (float)(fetch("SELECT COALESCE(SUM(`total_amount`),0) as t FROM `wingo_bets`")['t'] ?? 0);
$todayBets = (float)(fetch("SELECT COALESCE(SUM(`total_amount`),0) as t FROM `wingo_bets` WHERE DATE(`created_at`)=CURDATE()")['t'] ?? 0);
$totalPayout = (float)(fetch("SELECT COALESCE(SUM(`win_amount`),0) as t FROM `wingo_bets` WHERE `result`='win'")['t'] ?? 0);
$todayPayout = (float)(fetch("SELECT COALESCE(SUM(`win_amount`),0) as t FROM `wingo_bets` WHERE `result`='win' AND DATE(`created_at`)=CURDATE()")['t'] ?? 0);

$siteProfit = $totalDeposited - $totalWithdrawn;
$todayProfit = $todayDeposited - $todayWithdrawnTotal;
$gameProfit = $totalBets - $totalPayout;
$todayGameProfit = $todayBets - $todayPayout;

// Recent deposits & withdrawals
$recentDep = fetchAll("SELECT d.*,u.`name`,u.`phone` FROM `deposits` d JOIN `users` u ON d.`user_id`=u.`id` WHERE d.`status`='pending' ORDER BY d.`created_at` DESC LIMIT 5");
$recentWd = fetchAll("SELECT w.*,u.`name`,u.`phone` FROM `withdrawals` w JOIN `users` u ON w.`user_id`=u.`id` WHERE w.`status`='pending' ORDER BY w.`created_at` DESC LIMIT 5");

require_once __DIR__ . '/includes/admin-header.php';
?>

<!-- Stats Grid -->
<div class="stat-grid">
    <div class="stat-card sc-blue">
        <div class="sc-icon"><i class="fas fa-users"></i></div>
        <div class="sc-info">
            <div class="sc-value"><?php echo number_format($totalUsers); ?></div>
            <div class="sc-label">Total Users</div>
            <div class="sc-sub">+<?php echo $todayUsers; ?> today · <?php echo $activeUsers; ?> active 24h</div>
        </div>
    </div>
    <div class="stat-card sc-green">
        <div class="sc-icon"><i class="fas fa-arrow-down"></i></div>
        <div class="sc-info">
            <div class="sc-value">₹<?php echo number_format($totalDeposited); ?></div>
            <div class="sc-label">Total Deposits</div>
            <div class="sc-sub">Today: ₹<?php echo number_format($todayDeposited); ?> · <?php echo $pendingDep; ?> pending</div>
        </div>
    </div>
    <div class="stat-card sc-red">
        <div class="sc-icon"><i class="fas fa-arrow-up"></i></div>
        <div class="sc-info">
            <div class="sc-value">₹<?php echo number_format($totalWithdrawn); ?></div>
            <div class="sc-label">Total Withdrawals</div>
            <div class="sc-sub">Today: ₹<?php echo number_format($todayWithdrawnTotal); ?> · <?php echo $pendingWd; ?> pending</div>
        </div>
    </div>
    <div class="stat-card sc-gold">
        <div class="sc-icon"><i class="fas fa-coins"></i></div>
        <div class="sc-info">
            <div class="sc-value <?php echo $siteProfit>=0?'text-green':'text-red'; ?>">₹<?php echo number_format($siteProfit); ?></div>
            <div class="sc-label">Net Profit (Dep-Wd)</div>
            <div class="sc-sub">Today: ₹<?php echo number_format($todayProfit); ?></div>
        </div>
    </div>
    <div class="stat-card sc-purple">
        <div class="sc-icon"><i class="fas fa-gamepad"></i></div>
        <div class="sc-info">
            <div class="sc-value">₹<?php echo number_format($totalBets); ?></div>
            <div class="sc-label">Total Bets</div>
            <div class="sc-sub">Today: ₹<?php echo number_format($todayBets); ?></div>
        </div>
    </div>
    <div class="stat-card sc-orange">
        <div class="sc-icon"><i class="fas fa-trophy"></i></div>
        <div class="sc-info">
            <div class="sc-value <?php echo $gameProfit>=0?'text-green':'text-red'; ?>">₹<?php echo number_format($gameProfit); ?></div>
            <div class="sc-label">Game Profit (Bets-Wins)</div>
            <div class="sc-sub">Today: ₹<?php echo number_format($todayGameProfit); ?></div>
        </div>
    </div>
</div>

<!-- Pending Actions -->
<div class="admin-grid-2">
    <!-- Pending Deposits -->
    <div class="admin-card">
        <div class="ac-header">
            <h3>📥 Pending Deposits (<?php echo $pendingDep; ?>)</h3>
            <a href="/admin/deposits.php" class="ac-link">View All →</a>
        </div>
        <div class="ac-body">
            <?php if (empty($recentDep)): ?>
            <p class="ac-empty">No pending deposits</p>
            <?php else: foreach ($recentDep as $d): ?>
            <div class="ac-row">
                <div class="ac-row-info">
                    <div class="ac-row-title"><?php echo htmlspecialchars($d['name']); ?> (<?php echo maskPhone($d['phone']); ?>)</div>
                    <div class="ac-row-sub">UTR: <?php echo $d['utr_number']; ?> · <?php echo timeAgo($d['created_at']); ?></div>
                </div>
                <div class="ac-row-amount text-green">₹<?php echo number_format((float)$d['amount']); ?></div>
            </div>
            <?php endforeach; endif; ?>
        </div>
    </div>

    <!-- Pending Withdrawals -->
    <div class="admin-card">
        <div class="ac-header">
            <h3>📤 Pending Withdrawals (<?php echo $pendingWd; ?>)</h3>
            <a href="/admin/withdrawals.php" class="ac-link">View All →</a>
        </div>
        <div class="ac-body">
            <?php if (empty($recentWd)): ?>
            <p class="ac-empty">No pending withdrawals</p>
            <?php else: foreach ($recentWd as $w): ?>
            <div class="ac-row">
                <div class="ac-row-info">
                    <div class="ac-row-title"><?php echo htmlspecialchars($w['name']); ?> (<?php echo maskPhone($w['phone']); ?>)</div>
                    <div class="ac-row-sub"><?php echo strtoupper($w['payment_method']); ?>: <?php echo $w['upi_id'] ?: '****'.substr($w['account_number']??'',-4); ?> · <?php echo timeAgo($w['created_at']); ?></div>
                </div>
                <div class="ac-row-amount text-red">₹<?php echo number_format((float)$w['amount']); ?></div>
            </div>
            <?php endforeach; endif; ?>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>