/**
 * HINDUSTAN CLUB — Admin Panel JavaScript
 */
(function() {
'use strict';

// CSRF Token
window.ADMIN_CSRF = document.querySelector('meta[name="csrf-token"]')?.content || '';

// ===== Toggle Sidebar =====
window.toggleSidebar = function() {
    var sidebar = document.getElementById('adminSidebar');
    if (sidebar) {
        sidebar.classList.toggle('open');
    }
};

// Close sidebar when clicking outside on mobile
document.addEventListener('click', function(e) {
    var sidebar = document.getElementById('adminSidebar');
    if (sidebar && sidebar.classList.contains('open')) {
        if (!sidebar.contains(e.target) && !e.target.closest('.at-menu-btn')) {
            sidebar.classList.remove('open');
        }
    }
});

// ===== Admin AJAX Helper =====
window.adminAjax = function(url, data, successCallback, errorCallback) {
    if (typeof data === 'object') {
        if (!data.csrf_token) data.csrf_token = ADMIN_CSRF;
    }
    
    $.ajax({
        url: url,
        method: 'POST',
        data: data,
        dataType: 'json',
        timeout: 30000,
        success: function(response) {
            if (response.data && response.data.redirect) {
                window.location.href = response.data.redirect;
                return;
            }
            if (successCallback) successCallback(response);
        },
        error: function(xhr, status, error) {
            console.error('Admin AJAX Error:', status, error);
            if (xhr.status === 401 || xhr.status === 403) {
                window.location.href = '/admin/';
                return;
            }
            
            var msg = 'Network error. Please try again.';
            try {
                var resp = JSON.parse(xhr.responseText);
                if (resp.message) msg = resp.message;
            } catch(e) {}
            
            if (errorCallback) {
                errorCallback(xhr, status, error);
            } else {
                adminError(msg);
            }
        }
    });
};

// ===== SweetAlert Wrappers =====
window.adminToast = function(message, icon) {
    Swal.fire({
        toast: true,
        position: 'top-end',
        icon: icon || 'success',
        title: message,
        showConfirmButton: false,
        timer: 2500,
        timerProgressBar: true,
        background: '#1e293b',
        color: '#e2e8f0',
    });
};

window.adminError = function(message) {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        text: message || 'Something went wrong',
        background: '#1e293b',
        color: '#e2e8f0',
        confirmButtonColor: '#ef4444',
    });
};

window.adminSuccess = function(title, text, callback) {
    Swal.fire({
        icon: 'success',
        title: title || 'Success',
        text: text || '',
        background: '#1e293b',
        color: '#e2e8f0',
        confirmButtonColor: '#FFD700',
    }).then(function(result) {
        if (callback) callback(result);
    });
};

window.adminConfirm = function(title, text, confirmText, callback) {
    Swal.fire({
        icon: 'warning',
        title: title,
        text: text,
        showCancelButton: true,
        confirmButtonColor: '#FFD700',
        cancelButtonColor: '#475569',
        confirmButtonText: confirmText || 'Confirm',
        cancelButtonText: 'Cancel',
        background: '#1e293b',
        color: '#e2e8f0',
    }).then(function(result) {
        if (result.isConfirmed && callback) callback();
    });
};

// ===== Button Loading State =====
window.adminSetLoading = function(btn, loading, originalText) {
    if (!btn) return;
    if (loading) {
        btn.disabled = true;
        btn.dataset.originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Wait...';
    } else {
        btn.disabled = false;
        btn.innerHTML = originalText || btn.dataset.originalText || 'Submit';
    }
};

// ===== Format Number =====
window.adminFormatINR = function(amount) {
    amount = parseFloat(amount) || 0;
    return '₹' + amount.toLocaleString('en-IN', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
};

// ===== Auto-refresh pending counts every 30s =====
setInterval(function() {
    $.getJSON('/admin/api/quick-stats.php', function(data) {
        // Silently update badges if needed
    }).fail(function() {
        // Ignore silently
    });
}, 30000);

// ===== Keyboard Shortcuts =====
document.addEventListener('keydown', function(e) {
    // Ctrl+K — Focus search if present
    if ((e.ctrlKey || e.metaKey) && e.key === 'k') {
        e.preventDefault();
        var searchInput = document.querySelector('.admin-search-form input[type="text"]');
        if (searchInput) searchInput.focus();
    }
});

// ===== Handle sidebar state on resize =====
window.addEventListener('resize', function() {
    var sidebar = document.getElementById('adminSidebar');
    if (window.innerWidth > 768 && sidebar) {
        sidebar.classList.remove('open');
    }
});

// ===== Tooltip on truncated text =====
document.querySelectorAll('.admin-table td').forEach(function(td) {
    if (td.scrollWidth > td.clientWidth) {
        td.title = td.textContent.trim();
    }
});

})();
// ============================================================
// v2.0 Enhancements — 3D scroll, wallet display, UPI utils
// ============================================================

// Topbar glow on scroll
window.addEventListener('scroll', function() {
    var topbar = document.querySelector('.admin-topbar');
    if (topbar) {
        topbar.classList.toggle('scrolled', window.scrollY > 10);
    }
});

// Wallet balance formatter — 3 types
window.formatWallet = function(wallet) {
    if (!wallet) return '₹0';
    var dep = parseFloat(wallet.deposit_balance || 0);
    var earn = parseFloat(wallet.earning_balance || 0);
    var bonus = parseFloat(wallet.bonus_balance || 0);
    return '<span class="admin-badge wallet-deposit" title="Deposit">D:₹'+dep.toFixed(0)+'</span> '+
           '<span class="admin-badge wallet-earning" title="Earning">E:₹'+earn.toFixed(0)+'</span> '+
           '<span class="admin-badge wallet-bonus" title="Bonus">B:₹'+bonus.toFixed(0)+'</span>';
};

// Sidebar touch support for mobile
var startX = 0;
document.addEventListener('touchstart', function(e) { startX = e.touches[0].clientX; });
document.addEventListener('touchend', function(e) {
    var diff = e.changedTouches[0].clientX - startX;
    var sidebar = document.getElementById('adminSidebar');
    if (!sidebar) return;
    if (diff > 60 && startX < 30) sidebar.classList.add('open');
    if (diff < -60) sidebar.classList.remove('open');
});

// Auto close sidebar overlay on mobile
document.addEventListener('click', function(e) {
    var sidebar = document.getElementById('adminSidebar');
    if (!sidebar) return;
    if (window.innerWidth <= 768 && sidebar.classList.contains('open')) {
        if (!sidebar.contains(e.target) && !e.target.closest('.at-menu-btn')) {
            sidebar.classList.remove('open');
        }
    }
});
