<?php
/**
 * Admin Users API
 */
require_once __DIR__ . '/../includes/admin-check.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') jsonResponse(false, 'Invalid method');
$csrf = $_POST['csrf_token'] ?? '';
if (!verifyCSRFToken($csrf)) jsonResponse(false, 'Invalid token');

$action = sanitize($_POST['action'] ?? '');

switch ($action) {
    case 'ban_user':
        $uid = intval($_POST['user_id'] ?? 0);
        $user = getUserById($uid);
        if (!$user) jsonResponse(false, 'User not found');
        update('users', ['status' => 'banned'], 'id=?', [$uid]);
        logAdmin('ban_user', "Banned user #$uid ({$user['name']})");
        addNotification($uid, '⛔ Account Suspended', 'Your account has been suspended. Contact support.', 'system');
        jsonResponse(true, 'User banned');
        break;
    
    case 'unban_user':
        $uid = intval($_POST['user_id'] ?? 0);
        update('users', ['status' => 'active'], 'id=?', [$uid]);
        logAdmin('unban_user', "Unbanned user #$uid");
        jsonResponse(true, 'User unbanned');
        break;
    
    case 'add_balance':
        $uid = intval($_POST['user_id'] ?? 0);
        $amount = round(floatval($_POST['amount'] ?? 0), 2);
        $walletType = sanitize($_POST['wallet'] ?? 'main');
        $reason = sanitize($_POST['reason'] ?? 'Admin adjustment');
        if ($amount <= 0 || $amount > 1000000) jsonResponse(false, 'Invalid amount');
        if ($walletType === 'bonus') {
            addToBonusWallet($uid, $amount, 'admin_add', $reason);
        } else {
            addToMainWallet($uid, $amount, 'admin_add', $reason);
        }
        logAdmin('add_balance', "Added ₹$amount to user #$uid ($walletType): $reason");
        addNotification($uid, '💰 Balance Added', "+₹" . number_format($amount, 2) . " added by admin: $reason", 'system');
        jsonResponse(true, 'Balance added');
        break;
    
    case 'deduct_balance':
        $uid = intval($_POST['user_id'] ?? 0);
        $amount = round(floatval($_POST['amount'] ?? 0), 2);
        $walletType = sanitize($_POST['wallet'] ?? 'main');
        $reason = sanitize($_POST['reason'] ?? 'Admin adjustment');
        if ($amount <= 0) jsonResponse(false, 'Invalid amount');
        try {
            if ($walletType === 'bonus') {
                deductFromBonusWallet($uid, $amount, 'admin_deduct', $reason);
            } else {
                deductFromMainWallet($uid, $amount, 'admin_deduct', $reason);
            }
            logAdmin('deduct_balance', "Deducted ₹$amount from user #$uid ($walletType): $reason");
            addNotification($uid, '➖ Balance Deducted', "-₹" . number_format($amount, 2) . " deducted: $reason", 'system');
            jsonResponse(true, 'Balance deducted');
        } catch (Exception $e) {
            jsonResponse(false, $e->getMessage());
        }
        break;
    
    case 'set_phase':
        $uid = intval($_POST['user_id'] ?? 0);
        $phase = max(1, min(4, intval($_POST['phase'] ?? 2)));
        update('user_algorithm_data', ['current_phase' => $phase], 'user_id=?', [$uid]);
        logAdmin('set_phase', "Set user #$uid to phase $phase");
        jsonResponse(true, 'Phase updated');
        break;
    
    default:
        jsonResponse(false, 'Invalid action');
}