<?php
/**
 * Quick stats API for admin header auto-refresh
 */
require_once __DIR__ . '/../includes/admin-check.php';

header('Content-Type: application/json');

$pendingDeposits = (int)(fetch("SELECT COUNT(*) as c FROM `deposits` WHERE `status`='pending'")['c'] ?? 0);
$pendingWithdrawals = (int)(fetch("SELECT COUNT(*) as c FROM `withdrawals` WHERE `status`='pending'")['c'] ?? 0);
$onlineEstimate = (int)(fetch("SELECT COUNT(*) as c FROM `users` WHERE `last_login` > DATE_SUB(NOW(), INTERVAL 15 MINUTE)")['c'] ?? 0);

echo json_encode([
    'success' => true,
    'data' => [
        'pending_deposits'    => $pendingDeposits,
        'pending_withdrawals' => $pendingWithdrawals,
        'online_estimate'     => $onlineEstimate,
    ]
]);