<?php
/**
 * Admin Games API — Wingo control, Algorithm, Spin, Game Icons
 */
require_once __DIR__ . '/../includes/admin-check.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') jsonResponse(false, 'Invalid method');
$csrf = $_POST['csrf_token'] ?? '';
if (!verifyCSRFToken($csrf)) jsonResponse(false, 'Invalid token');

$action = sanitize($_POST['action'] ?? '');

switch ($action) {
    case 'set_manual_result':
        $duration = intval($_POST['game_duration'] ?? 1);
        $periodNumber = sanitize($_POST['period_number'] ?? '');
        $resultNumber = intval($_POST['result_number'] ?? -1);
        if ($resultNumber < 0 || $resultNumber > 9) jsonResponse(false, 'Invalid number (0-9)');
        if (empty($periodNumber)) jsonResponse(false, 'Period number required');
        insert('wingo_manual_results', ['game_duration'=>$duration,'period_number'=>$periodNumber,'result_number'=>$resultNumber,'is_used'=>0,'created_by'=>$adminId]);
        logAdmin('set_manual_result', "Set manual result $resultNumber for $duration min period $periodNumber");
        jsonResponse(true, 'Manual result set');
        break;

    case 'update_algorithm':
        $settings = $_POST['settings'] ?? [];
        if (!is_array($settings)) jsonResponse(false, 'Invalid data');
        foreach ($settings as $key => $value) {
            $key = sanitize($key);
            $value = sanitize($value);
            update('algorithm_settings', ['value' => $value], '`key`=?', [$key]);
        }
        logAdmin('update_algorithm', 'Updated algorithm settings');
        jsonResponse(true, 'Algorithm settings updated');
        break;

    case 'update_spin':
        $segId = intval($_POST['segment_id'] ?? 0);
        $prob = floatval($_POST['probability'] ?? 0);
        $amount = floatval($_POST['amount'] ?? 0);
        if ($segId <= 0) jsonResponse(false, 'Invalid segment');
        update('spin_config', ['probability'=>$prob,'amount'=>$amount], 'id=?', [$segId]);
        logAdmin('update_spin', "Updated spin segment #$segId: prob=$prob, amount=$amount");
        jsonResponse(true, 'Spin updated');
        break;

    case 'update_game_icon':
        $gameId = intval($_POST['game_id'] ?? 0);
        $icon = sanitize(trim($_POST['icon'] ?? ''));
        $iconType = sanitize($_POST['icon_type'] ?? 'fa');
        $iconBg = sanitize($_POST['icon_bg_color'] ?? '#FFD700');
        if ($gameId <= 0) jsonResponse(false, 'Invalid game ID');
        if (!in_array($iconType, ['fa','emoji','image'])) jsonResponse(false, 'Invalid icon type');
        if (empty($icon)) jsonResponse(false, 'Icon required');
        // Sanitize color
        if (!preg_match('/^#[0-9a-fA-F]{3,8}$/', $iconBg)) $iconBg = '#FFD700';
        update('games_config', [
            'icon'          => $icon,
            'icon_type'     => $iconType,
            'icon_bg_color' => $iconBg,
        ], 'id=?', [$gameId]);
        logAdmin('update_game_icon', "Updated icon for game #$gameId: $icon ($iconType)");
        jsonResponse(true, 'Icon updated');
        break;

    default:
        jsonResponse(false, 'Invalid action');
}
