<?php
define('ADMIN_PAGE', 'algorithm');
define('ADMIN_TITLE', 'Algorithm Control');
require_once __DIR__ . '/includes/admin-check.php';

$algoSettings = fetchAll("SELECT * FROM `algorithm_settings` ORDER BY `id` ASC");

$phaseStats = fetchAll("SELECT `current_phase`, COUNT(*) as cnt FROM `user_algorithm_data` GROUP BY `current_phase` ORDER BY `current_phase`");

require_once __DIR__ . '/includes/admin-header.php';
?>

<div class="admin-card">
    <div class="ac-header"><h3>🧠 Algorithm Settings</h3></div>
    <div class="ac-body">
        <form id="algoForm">
            <?php foreach ($algoSettings as $s): ?>
            <div style="display:flex;align-items:center;gap:10px;padding:10px;border-bottom:1px solid rgba(255,255,255,.06)">
                <div style="flex:1">
                    <div style="font-size:12px;font-weight:600;color:#fff"><?php echo htmlspecialchars($s['key']); ?></div>
                    <div style="font-size:10px;color:#888"><?php echo htmlspecialchars($s['description'] ?? ''); ?></div>
                </div>
                <input type="text" name="settings[<?php echo htmlspecialchars($s['key']); ?>]" value="<?php echo htmlspecialchars($s['value']); ?>" class="admin-input" style="width:120px;text-align:center">
            </div>
            <?php endforeach; ?>
            <div style="padding:14px">
                <button type="button" onclick="saveAlgorithm()" class="admin-btn admin-btn-primary"><i class="fas fa-save"></i> Save All</button>
            </div>
        </form>
    </div>
</div>

<div class="admin-card" style="margin-top:16px">
    <div class="ac-header"><h3>📊 Phase Distribution</h3></div>
    <div class="ac-body">
        <div style="display:flex;gap:10px">
            <?php
            $phaseNames = [1=>'HOOK',2=>'NORMAL',3=>'TRAP',4=>'MILK'];
            $phaseColors = [1=>'#22c55e',2=>'#3b82f6',3=>'#eab308',4=>'#ef4444'];
            foreach ($phaseStats as $ps):
                $p = (int)$ps['current_phase'];
            ?>
            <div style="flex:1;background:rgba(255,255,255,.04);border-radius:8px;padding:14px;text-align:center">
                <div style="font-size:20px;font-weight:700;color:<?php echo $phaseColors[$p]??'#fff'; ?>"><?php echo $ps['cnt']; ?></div>
                <div style="font-size:10px;color:#888">Phase <?php echo $p; ?> — <?php echo $phaseNames[$p]??'?'; ?></div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<script>
function saveAlgorithm() {
    var formData = {};
    document.querySelectorAll('#algoForm input[name]').forEach(function(inp) {
        var match = inp.name.match(/settings\[(.+)\]/);
        if (match) formData['settings[' + match[1] + ']'] = inp.value;
    });
    formData.action = 'update_algorithm';
    adminAjax('/admin/api/games.php', formData, function(r) {
        if(r.success) adminToast('Algorithm saved!');
        else adminError(r.message);
    });
}
</script>

<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>