<?php
define('ADMIN_PAGE', 'activitylog');
define('ADMIN_TITLE', 'Activity Log');
require_once __DIR__ . '/includes/admin-check.php';
$page = max(1, intval($_GET['page'] ?? 1));
$perPage = 30;
$offset = ($page-1)*$perPage;
$total = rowCount('admin_activity_log');
$totalPages = max(1, ceil($total/$perPage));
$logs = fetchAll("SELECT l.*, a.`username` FROM `admin_activity_log` l LEFT JOIN `admin_users` a ON l.`admin_id`=a.`id` ORDER BY l.`created_at` DESC LIMIT $perPage OFFSET $offset");
require_once __DIR__ . '/includes/admin-header.php';
?>
<div class="admin-card">
    <div class="ac-header"><h3>📝 Activity Log</h3></div>
    <div class="admin-table-wrap">
        <table class="admin-table">
            <thead><tr><th>Time</th><th>Admin</th><th>Action</th><th>Description</th><th>IP</th></tr></thead>
            <tbody>
            <?php foreach ($logs as $l): ?>
            <tr>
                <td style="font-size:11px;white-space:nowrap"><?php echo formatDate($l['created_at'],'d M H:i'); ?></td>
                <td><?php echo htmlspecialchars($l['username'] ?? 'Unknown'); ?></td>
                <td><span class="admin-badge badge-info"><?php echo htmlspecialchars($l['action']); ?></span></td>
                <td style="font-size:11px;max-width:300px;overflow:hidden;text-overflow:ellipsis"><?php echo htmlspecialchars($l['description'] ?? ''); ?></td>
                <td style="font-size:10px;color:#888"><?php echo $l['ip_address']; ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php if ($totalPages > 1): ?>
    <div class="admin-pagination">
        <?php for ($p = max(1,$page-3); $p <= min($totalPages,$page+3); $p++): ?>
        <a href="?page=<?php echo $p; ?>" class="admin-page-btn <?php echo $p===$page?'active':''; ?>"><?php echo $p; ?></a>
        <?php endfor; ?>
    </div>
    <?php endif; ?>
</div>
<?php require_once __DIR__ . '/includes/admin-footer.php'; ?>