<?php
http_response_code(404);
$isLoggedIn = false;
try {
    require_once __DIR__ . '/config.php';
    $isLoggedIn = isLoggedIn();
} catch (Exception $e) {}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <title>404 — Page Not Found</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
    *{margin:0;padding:0;box-sizing:border-box}
    body{font-family:'Poppins',sans-serif;background:#1a1a2e;color:#fff;min-height:100vh;display:flex;align-items:center;justify-content:center;text-align:center;padding:20px}
    .container{max-width:360px}
    .code{font-size:80px;font-weight:800;color:#FFD700;line-height:1;margin-bottom:8px}
    .msg{font-size:16px;color:#ccc;margin-bottom:6px}
    .sub{font-size:12px;color:#666;margin-bottom:24px}
    .btn{display:inline-flex;align-items:center;gap:6px;padding:12px 28px;border-radius:10px;background:linear-gradient(135deg,#FFD700,#FFA000);color:#1a1a2e;font-weight:600;font-size:14px;text-decoration:none;transition:.2s}
    .btn:hover{filter:brightness(1.1);color:#1a1a2e}
    </style>
</head>
<body>
<div class="container">
    <div class="code">404</div>
    <div class="msg">Page Not Found</div>
    <div class="sub">The page you're looking for doesn't exist or has been moved.</div>
    <a href="<?php echo $isLoggedIn ? '/user/dashboard.php' : '/'; ?>" class="btn">← Go to <?php echo $isLoggedIn ? 'Dashboard' : 'Home'; ?></a>
</div>
</body>
</html>